/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.class_1208;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_155;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2522;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3518;
import net.minecraft.class_3551;
import net.minecraft.class_3611;
import net.minecraft.class_5218;
import net.minecraft.class_5257;
import net.minecraft.class_7923;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.Fluid;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.UnsafeValues;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_20_R1.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_20_R1.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_20_R1.util.Commodore;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final UnsafeValues INSTANCE = new CraftMagicNumbers();
    public static final Map<class_2248, Material> BLOCK_MATERIAL = new HashMap<class_2248, Material>();
    public static final Map<class_1792, Material> ITEM_MATERIAL = new HashMap<class_1792, Material>();
    public static final BiMap<class_3611, Fluid> FLUIDTYPE_FLUID = HashBiMap.create();
    public static final Map<Material, class_1792> MATERIAL_ITEM = new HashMap<Material, class_1792>();
    public static final Map<Material, class_2248> MATERIAL_BLOCK = new HashMap<Material, class_2248>();
    private static final List<String> SUPPORTED_API;

    private CraftMagicNumbers() {
    }

    public static class_2680 getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static class_2680 getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(class_2680 data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.method_26204())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static class_1792 getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(class_1792 item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(class_2248 block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(class_1792 item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Fluid getFluid(class_3611 fluid) {
        return (Fluid)FLUIDTYPE_FLUID.get((Object)fluid);
    }

    public static class_1792 getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static class_2248 getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static class_3611 getFluid(Fluid fluid) {
        return (class_3611)FLUIDTYPE_FLUID.inverse().get((Object)fluid);
    }

    public static class_2960 key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public static byte toLegacyData(class_2680 data) {
        return CraftLegacy.toLegacyData(data);
    }

    @Override
    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    @Override
    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    @Override
    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    @Override
    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    @Override
    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    @Override
    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial(material);
        }
        Dynamic name = new Dynamic((DynamicOps)class_2509.field_11560, (Object)class_2519.method_23256((String)("minecraft:" + material.toLowerCase(Locale.ROOT))));
        if (name.equals((Object)(converted = class_3551.method_15450().update(class_1208.field_5713, name, version, this.getDataVersion())))) {
            converted = class_3551.method_15450().update(class_1208.field_5731, name, version, this.getDataVersion());
        }
        return Material.matchMaterial(converted.asString(""));
    }

    public String getMappingsVersion() {
        return "bcf3dcb22ad42792794079f9443df2c0";
    }

    @Override
    public int getDataVersion() {
        return class_155.method_16673().method_37912().method_38494();
    }

    @Override
    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        class_1799 nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.method_7980(class_2522.method_10718((String)arguments));
        }
        catch (CommandSyntaxException ex) {
            Logger.getLogger(CraftMagicNumbers.class.getName()).log(Level.SEVERE, null, ex);
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(Objects.requireNonNull(BukkitExtraConstants.getServer()).method_27050(class_5218.field_24186).toFile(), "bukkit");
    }

    @Override
    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        Preconditions.checkArgument((Bukkit.getAdvancement(key) == null ? 1 : 0) != 0, (String)"Advancement %s already exists", (Object)key);
        class_2960 minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = (JsonElement)class_2989.field_13405.fromJson(advancement, JsonElement.class);
        JsonObject jsonobject = class_3518.method_15295((JsonElement)jsonelement, (String)"advancement");
        class_161.class_162 nms = class_161.class_162.method_692((JsonObject)jsonobject, (class_5257)new class_5257(minecraftkey, BukkitExtraConstants.getServer().method_3857()));
        if (nms != null) {
            BukkitExtraConstants.getServer().method_3851().field_13404.method_711((Map)Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
            Advancement bukkit = Bukkit.getAdvancement(key);
            if (bukkit != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + key, ex);
                }
                BukkitExtraConstants.getServer().method_3760().method_14572();
                return bukkit;
            }
        }
        return null;
    }

    @Override
    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    @Override
    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        String minimumVersion = BukkitExtraConstants.getServer().bridge$server().minimumAPI;
        int minimumIndex = SUPPORTED_API.indexOf(minimumVersion);
        if (pdf.getAPIVersion() != null) {
            int pluginIndex = SUPPORTED_API.indexOf(pdf.getAPIVersion());
            if (pluginIndex == -1) {
                throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
            }
            if (pluginIndex < minimumIndex) {
                throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
            }
        } else if (minimumIndex == -1) {
            CraftLegacy.init();
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        } else {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    @Override
    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        try {
            clazz = Commodore.convert(clazz, !CraftMagicNumbers.isLegacy(pdf));
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        Multimap nmsDefaultAttributes = CraftMagicNumbers.getItem(material).method_7844(CraftEquipmentSlot.getNMS(slot));
        for (Map.Entry mapEntry : nmsDefaultAttributes.entries()) {
            Attribute attribute = CraftAttributeMap.fromMinecraft(class_7923.field_41190.method_10221((Object)((class_1320)mapEntry.getKey())).toString());
            defaultAttributes.put((Object)attribute, (Object)CraftAttributeInstance.convert((class_1322)mapEntry.getValue(), slot));
        }
        return defaultAttributes.build();
    }

    @Override
    public CreativeCategory getCreativeCategory(Material material) {
        return CreativeCategory.BUILDING_BLOCKS;
    }

    @Override
    public String getBlockTranslationKey(Material material) {
        class_2248 block = CraftMagicNumbers.getBlock(material);
        return block != null ? block.method_9539() : null;
    }

    @Override
    public String getItemTranslationKey(Material material) {
        class_1792 item = CraftMagicNumbers.getItem(material);
        return item != null ? item.method_7876() : null;
    }

    @Override
    public String getTranslationKey(EntityType entityType) {
        Preconditions.checkArgument((entityType.getName() != null ? 1 : 0) != 0, (String)"Invalid name of EntityType %s for translation key", (Object)entityType);
        String mods = ServerAPI.entityTypeMap0.get(entityType).method_5882();
        return class_1299.method_5898((String)entityType.getName()).map(class_1299::method_5882).orElse(mods);
    }

    @Override
    public String getTranslationKey(ItemStack itemStack) {
        class_1799 nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.method_7909().method_7866(nmsItemStack);
    }

    @Override
    public FeatureFlag getFeatureFlag(NamespacedKey namespacedKey) {
        Preconditions.checkArgument((namespacedKey != null ? 1 : 0) != 0, (Object)"NamespaceKey cannot be null");
        return CraftFeatureFlag.getFromNMS(namespacedKey);
    }

    static {
        for (class_2248 block2 : class_7923.field_41175) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial(class_7923.field_41175.method_10221((Object)block2).method_12832().toUpperCase(Locale.ROOT)));
        }
        for (class_1792 item2 : class_7923.field_41178) {
            ITEM_MATERIAL.put(item2, Material.getMaterial(class_7923.field_41178.method_10221((Object)item2).method_12832().toUpperCase(Locale.ROOT)));
        }
        for (class_3611 fluidType : class_7923.field_41173) {
            Fluid fluid;
            if (!class_7923.field_41173.method_10221((Object)fluidType).method_12836().equals("minecraft") || (fluid = Registry.FLUID.get(CraftNamespacedKey.fromMinecraft(class_7923.field_41173.method_10221((Object)fluidType)))) == null) continue;
            FLUIDTYPE_FLUID.put((Object)fluidType, (Object)fluid);
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            class_2960 key = CraftMagicNumbers.key(material);
            class_7923.field_41178.method_17966(key).ifPresent(item -> MATERIAL_ITEM.put(material, (class_1792)item));
            class_7923.field_41175.method_17966(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (class_2248)block));
        }
        SUPPORTED_API = Arrays.asList("1.13", "1.14", "1.15", "1.16", "1.17", "1.18", "1.19", "1.20");
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

