/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.network.download;

import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.config.BannerConfigUtil;
import com.mohistmc.tools.ConnectionUtil;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    CHINA("https://libraries.mohistmc.cn:25119/releases/"),
    GITHUB("https://mohistmc.github.io/maven/");

    public static final DownloadSource defaultSource;
    public final String url;

    public static DownloadSource get() {
        String ds = BannerConfigUtil.defaultSource();
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            if (!ConnectionUtil.canAccess((String)me.url.replace("releases/", ""))) {
                if (ds.equals("CHINA")) {
                    DownloadSource urL = MOHIST;
                    if (!ConnectionUtil.canAccess((String)urL.url)) {
                        return GITHUB;
                    }
                }
                return GITHUB;
            }
            return me;
        }
        return defaultSource;
    }

    public static boolean isCN() {
        return BannerMCStart.I18N.isCN() && ConnectionUtil.measureLatency((String)DownloadSource.CHINA.url.replace("releases/", "")) < ConnectionUtil.measureLatency((String)DownloadSource.MOHIST.url);
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }

    static {
        defaultSource = DownloadSource.isCN() ? CHINA : MOHIST;
    }
}

