/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mohistmc.banner.injection.server.level.InjectionChunkHolder;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2673;
import net.minecraft.class_2680;
import net.minecraft.class_2761;
import net.minecraft.class_2765;
import net.minecraft.class_2767;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2960;
import net.minecraft.class_3193;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3765;
import net.minecraft.class_3767;
import net.minecraft.class_3898;
import net.minecraft.class_3902;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4706;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.FeatureFlag;
import org.bukkit.FluidCollisionMode;
import org.bukkit.GameRule;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Raid;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.StructureType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R1.CraftEffect;
import org.bukkit.craftbukkit.v1_20_R1.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_20_R1.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R1.CraftRaid;
import org.bukkit.craftbukkit.v1_20_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftSound;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.generator.strucutre.CraftStructure;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_20_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftStructureSearchResult;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.TimeSkipEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.StructureSearchResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftWorld
extends CraftRegionAccessor
implements World {
    public static final int CUSTOM_DIMENSION_OFFSET = 10;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    private final class_3218 world;
    private WorldBorder worldBorder;
    private World.Environment environment;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final ChunkGenerator generator;
    private final BiomeProvider biomeProvider;
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private static final Random rand = new Random();
    private static Map<String, class_1928.class_4313<?>> gamerules;
    private static Map<String, class_1928.class_4314<?>> gameruleDefinitions;
    private final World.Spigot spigot = new World.Spigot(){

        @Override
        public LightningStrike strikeLightning(Location loc, boolean isSilent) {
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)CraftWorld.this.world);
            lightning.method_24203(loc.getX(), loc.getY(), loc.getZ());
            lightning.banner$setIsSilent(isSilent);
            CraftWorld.this.world.strikeLightning((class_1297)lightning, LightningStrikeEvent.Cause.CUSTOM);
            return (LightningStrike)((Object)lightning.getBukkitEntity());
        }

        @Override
        public LightningStrike strikeLightningEffect(Location loc, boolean isSilent) {
            class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)CraftWorld.this.world);
            lightning.method_24203(loc.getX(), loc.getY(), loc.getZ());
            lightning.field_7184 = true;
            lightning.banner$setIsSilent(isSilent);
            CraftWorld.this.world.strikeLightning((class_1297)lightning, LightningStrikeEvent.Cause.CUSTOM);
            return (LightningStrike)((Object)lightning.getBukkitEntity());
        }
    };

    public CraftWorld(class_3218 world, ChunkGenerator gen, BiomeProvider biomeProvider, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.biomeProvider = biomeProvider;
        this.environment = env;
    }

    @Override
    public Block getBlockAt(int x, int y, int z) {
        return CraftBlock.at((class_1936)this.world, class_2338.method_49637((double)x, (double)y, (double)z));
    }

    @Override
    public Location getSpawnLocation() {
        class_2338 spawn = this.world.method_43126();
        float yaw = this.world.method_43127();
        return CraftLocation.toBukkit(spawn, (World)this, yaw, 0.0f);
    }

    @Override
    public boolean setSpawnLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return this.equals(location.getWorld()) ? this.setSpawnLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getYaw()) : false;
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z, float angle) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.field_9232.method_187(class_2338.method_49637((double)x, (double)y, (double)z), angle);
            SpawnChangeEvent event = new SpawnChangeEvent((World)this, previousLocation);
            this.server.getPluginManager().callEvent(event);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean setSpawnLocation(int x, int y, int z) {
        return this.setSpawnLocation(x, y, z, 0.0f);
    }

    @Override
    public Chunk getChunkAt(int x, int z) {
        class_2818 chunk = (class_2818)this.world.method_8402(x, z, class_2806.field_12803, true);
        return new CraftChunk(chunk);
    }

    @Override
    @NotNull
    public Chunk getChunkAt(int x, int z, boolean generate) {
        if (generate) {
            return this.getChunkAt(x, z);
        }
        return new CraftChunk(this.getHandle(), x, z);
    }

    @Override
    public Chunk getChunkAt(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"null block");
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        return this.world.method_14178().isChunkLoaded(x, z);
    }

    @Override
    public boolean isChunkGenerated(int x, int z) {
        try {
            return this.isChunkLoaded(x, z) || ((Optional)this.world.method_14178().field_17254.method_23696(new class_1923(x, z)).get()).isPresent();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Chunk[] getLoadedChunks() {
        Long2ObjectLinkedOpenHashMap chunks = this.world.method_14178().field_17254.field_17220;
        return (Chunk[])chunks.values().stream().map(InjectionChunkHolder::getFullChunkNow).filter(Objects::nonNull).map(CraftChunk::new).toArray(Chunk[]::new);
    }

    @Override
    public void loadChunk(int x, int z) {
        this.loadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean unloadChunk(int x, int z) {
        return this.unloadChunk(x, z, true);
    }

    @Override
    public boolean unloadChunk(int x, int z, boolean save) {
        return this.unloadChunk0(x, z, save);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z) {
        if (this.isChunkLoaded(x, z)) {
            this.world.method_14178().method_17300(BukkitExtraConstants.PLUGIN, new class_1923(x, z), 1, (Object)class_3902.field_17274);
        }
        return true;
    }

    private boolean unloadChunk0(int x, int z, boolean save) {
        if (!this.isChunkLoaded(x, z)) {
            return true;
        }
        class_2818 chunk = this.world.method_8497(x, z);
        chunk.method_12008(!save);
        this.unloadChunkRequest(x, z);
        this.world.method_14178().purgeUnload();
        return !this.isChunkLoaded(x, z);
    }

    @Override
    public boolean regenerateChunk(int x, int z) {
        throw new UnsupportedOperationException("Not supported in this Minecraft version! Unless you can fix it, this is not a bug :)");
    }

    @Override
    public boolean refreshChunk(int x, int z) {
        class_3193 playerChunk = (class_3193)this.world.method_14178().field_17254.field_17220.get(class_1923.method_8331((int)x, (int)z));
        if (playerChunk == null) {
            return false;
        }
        playerChunk.method_16145().thenAccept(either -> either.left().ifPresent(chunk -> {
            List playersInRange = playerChunk.field_17210.method_17210(playerChunk.method_13994(), false);
            if (playersInRange.isEmpty()) {
                return;
            }
            class_2672 refreshPacket = new class_2672(chunk, this.world.method_22336(), null, null);
            for (class_3222 player : playersInRange) {
                if (player.field_13987 == null) continue;
                player.field_13987.method_14364((class_2596)refreshPacket);
            }
        }));
        return true;
    }

    @Override
    public boolean isChunkInUse(int x, int z) {
        return this.isChunkLoaded(x, z);
    }

    @Override
    public boolean loadChunk(int x, int z, boolean generate) {
        class_2791 chunk = this.world.method_14178().method_12121(x, z, generate ? class_2806.field_12803 : class_2806.field_12798, true);
        if (chunk instanceof class_2821) {
            chunk = this.world.method_14178().method_12121(x, z, class_2806.field_12803, true);
        }
        if (chunk instanceof class_2818) {
            this.world.method_14178().method_17297(BukkitExtraConstants.PLUGIN, new class_1923(x, z), 1, (Object)class_3902.field_17274);
            return true;
        }
        return false;
    }

    @Override
    public boolean isChunkLoaded(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    @Override
    public void loadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"null chunk");
        this.loadChunk(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean addPluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"null plugin");
        Preconditions.checkArgument((boolean)plugin.isEnabled(), (Object)"plugin is not enabled");
        class_3898.class_3216 chunkDistanceManager = this.world.method_14178().field_17254.field_17228;
        if (chunkDistanceManager.addRegionTicketAtDistance(BukkitExtraConstants.PLUGIN_TICKET, new class_1923(x, z), 2, (Object)plugin)) {
            this.getChunkAt(x, z);
            return true;
        }
        return false;
    }

    @Override
    public boolean removePluginChunkTicket(int x, int z, Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        class_3898.class_3216 chunkDistanceManager = this.world.method_14178().field_17254.field_17228;
        return chunkDistanceManager.removeRegionTicketAtDistance(BukkitExtraConstants.PLUGIN_TICKET, new class_1923(x, z), 2, (Object)plugin);
    }

    @Override
    public void removePluginChunkTickets(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin, (Object)"null plugin");
        class_3898.class_3216 chunkDistanceManager = this.world.method_14178().field_17254.field_17228;
        chunkDistanceManager.removeAllTicketsFor(BukkitExtraConstants.PLUGIN_TICKET, 31, (Object)plugin);
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets(int x, int z) {
        class_3898.class_3216 chunkDistanceManager = this.world.method_14178().field_17254.field_17228;
        class_4706 tickets = (class_4706)chunkDistanceManager.field_13895.get(class_1923.method_8331((int)x, (int)z));
        if (tickets == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (class_3228 ticket : tickets) {
            if (ticket.method_14281() != BukkitExtraConstants.PLUGIN_TICKET) continue;
            ret.add((Object)((Plugin)ticket.field_14022));
        }
        return ret.build();
    }

    @Override
    public Map<Plugin, Collection<Chunk>> getPluginChunkTickets() {
        HashMap<Plugin, ImmutableList.Builder> ret = new HashMap<Plugin, ImmutableList.Builder>();
        class_3898.class_3216 chunkDistanceManager = this.world.method_14178().field_17254.field_17228;
        for (Long2ObjectMap.Entry chunkTickets : chunkDistanceManager.field_13895.long2ObjectEntrySet()) {
            long chunkKey = chunkTickets.getLongKey();
            class_4706 tickets = (class_4706)chunkTickets.getValue();
            Chunk chunk = null;
            for (class_3228 ticket : tickets) {
                if (ticket.method_14281() != BukkitExtraConstants.PLUGIN_TICKET) continue;
                if (chunk == null) {
                    chunk = this.getChunkAt(class_1923.method_8325((long)chunkKey), class_1923.method_8332((long)chunkKey));
                }
                ret.computeIfAbsent((Plugin)ticket.field_14022, key -> ImmutableList.builder()).add((Object)chunk);
            }
        }
        return (Map)ret.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((ImmutableList.Builder)entry.getValue()).build()));
    }

    @Override
    public boolean isChunkForceLoaded(int x, int z) {
        return this.getHandle().method_17984().contains(class_1923.method_8331((int)x, (int)z));
    }

    @Override
    public void setChunkForceLoaded(int x, int z, boolean forced) {
        this.getHandle().method_17988(x, z, forced);
    }

    @Override
    public Collection<Chunk> getForceLoadedChunks() {
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        LongIterator longIterator = this.getHandle().method_17984().iterator();
        while (longIterator.hasNext()) {
            long coord = (Long)longIterator.next();
            chunks.add(this.getChunkAt(class_1923.method_8325((long)coord), class_1923.method_8332((long)coord)));
        }
        return Collections.unmodifiableCollection(chunks);
    }

    public class_3218 getHandle() {
        return this.world;
    }

    @Override
    public Item dropItem(Location loc, ItemStack item) {
        return this.dropItem(loc, item, null);
    }

    @Override
    public Item dropItem(Location loc, ItemStack item, Consumer<Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        class_1542 entity = new class_1542((class_1937)this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        Item itemEntity = (Item)((Object)entity.getBukkitEntity());
        entity.field_7202 = 10;
        if (function != null) {
            function.accept(itemEntity);
        }
        this.world.addFreshEntity((class_1297)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return itemEntity;
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item) {
        return this.dropItemNaturally(loc, item, null);
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item, Consumer<Item> function) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        double xs = (double)(this.world.field_9229.method_43057() * 0.5f) + 0.25;
        double ys = (double)(this.world.field_9229.method_43057() * 0.5f) + 0.25;
        double zs = (double)(this.world.field_9229.method_43057() * 0.5f) + 0.25;
        loc = loc.clone();
        loc = loc.clone().add(xs, ys, zs);
        return this.dropItem(loc, item, function);
    }

    @Override
    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        return this.spawnArrow(loc, velocity, speed, spread, Arrow.class);
    }

    @Override
    public <T extends AbstractArrow> T spawnArrow(Location loc, Vector velocity, float speed, float spread, Class<T> clazz) {
        class_1665 arrow;
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"Vector cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"clazz Entity for the arrow cannot be null");
        if (TippedArrow.class.isAssignableFrom(clazz)) {
            arrow = (class_1665)class_1299.field_6122.method_5883((class_1937)this.world);
            ((class_1667)arrow).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
        } else {
            arrow = SpectralArrow.class.isAssignableFrom(clazz) ? (class_1665)class_1299.field_6135.method_5883((class_1937)this.world) : (Trident.class.isAssignableFrom(clazz) ? (class_1665)class_1299.field_6127.method_5883((class_1937)this.world) : (class_1665)class_1299.field_6122.method_5883((class_1937)this.world));
        }
        arrow.method_5808(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.method_7485(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.method_8649((class_1297)arrow);
        return (T)((AbstractArrow)((Object)arrow.getBukkitEntity()));
    }

    @Override
    public LightningStrike strikeLightning(Location loc) {
        return this.strikeLightning0(loc, false);
    }

    @Override
    public LightningStrike strikeLightningEffect(Location loc) {
        return this.strikeLightning0(loc, true);
    }

    private LightningStrike strikeLightning0(Location loc, boolean isVisual) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        class_1538 lightning = (class_1538)class_1299.field_6112.method_5883((class_1937)this.world);
        lightning.method_24203(loc.getX(), loc.getY(), loc.getZ());
        lightning.method_29498(isVisual);
        this.world.strikeLightning((class_1297)lightning, LightningStrikeEvent.Cause.CUSTOM);
        return (LightningStrike)((Object)lightning.getBukkitEntity());
    }

    @Override
    public boolean generateTree(Location loc, TreeType type) {
        return this.generateTree(loc, rand, type);
    }

    @Override
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        this.world.banner$setCaptureTreeGeneration(true);
        this.world.banner$setCaptureBlockStates(true);
        boolean grownTree = this.generateTree(loc, type);
        this.world.banner$setCaptureTreeGeneration(false);
        this.world.banner$setCaptureBlockStates(false);
        if (grownTree) {
            for (BlockState blockstate : this.world.bridge$capturedBlockStates().values()) {
                class_2338 position = ((CraftBlockState)blockstate).getPosition();
                class_2680 oldBlock = this.world.method_8320(position);
                int flag = ((CraftBlockState)blockstate).getFlag();
                delegate.setBlockData(blockstate.getX(), blockstate.getY(), blockstate.getZ(), blockstate.getBlockData());
                class_2680 newBlock = this.world.method_8320(position);
                this.world.notifyAndUpdatePhysics(position, null, oldBlock, newBlock, newBlock, flag, 512);
            }
            this.world.bridge$capturedBlockStates().clear();
            return true;
        }
        this.world.bridge$capturedBlockStates().clear();
        return false;
    }

    @Override
    public String getName() {
        return this.world.field_24456.method_150();
    }

    @Override
    public UUID getUID() {
        return this.world.bridge$uuid();
    }

    @Override
    public NamespacedKey getKey() {
        return CraftNamespacedKey.fromMinecraft(this.world.method_27983().method_29177());
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + "}";
    }

    @Override
    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    @Override
    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    @Override
    public long getFullTime() {
        return this.world.method_8532();
    }

    @Override
    public void setFullTime(long time) {
        TimeSkipEvent event = new TimeSkipEvent(this, TimeSkipEvent.SkipReason.CUSTOM, time - this.world.method_8532());
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.world.method_29199(this.world.method_8532() + event.getSkipAmount());
        for (Player p : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p;
            if (cp.getHandle().field_13987 == null) continue;
            cp.getHandle().field_13987.method_14364((class_2596)new class_2761(cp.getHandle().method_37908().method_8510(), cp.getHandle().getPlayerTime(), cp.getHandle().method_37908().method_8450().method_8355(class_1928.field_19396)));
        }
    }

    @Override
    public long getGameTime() {
        return this.world.field_9232.method_188();
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power) {
        return this.createExplosion(x, y, z, power, false, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire) {
        return this.createExplosion(x, y, z, power, setFire, true);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(x, y, z, power, setFire, breakBlocks, null);
    }

    @Override
    public boolean createExplosion(double x, double y, double z, float power, boolean setFire, boolean breakBlocks, Entity source) {
        return !this.world.method_8537(source == null ? null : ((CraftEntity)source).getHandle(), x, y, z, power, setFire, breakBlocks ? class_1937.class_7867.field_40890 : class_1937.class_7867.field_40888).bridge$wasCanceled();
    }

    @Override
    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc, power, setFire, true);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks) {
        return this.createExplosion(loc, power, setFire, breakBlocks, null);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire, boolean breakBlocks, Entity source) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location is null");
        Preconditions.checkArgument((boolean)this.equals(loc.getWorld()), (Object)"Location not in world");
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire, breakBlocks, source);
    }

    @Override
    public World.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Override
    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    @Override
    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @Override
    public Block getHighestBlockAt(int x, int z) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z), z);
    }

    @Override
    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public Block getHighestBlockAt(int x, int z, HeightMap heightMap) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z, heightMap), z);
    }

    @Override
    public Block getHighestBlockAt(Location location, HeightMap heightMap) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ(), heightMap);
    }

    @Override
    public Biome getBiome(int x, int z) {
        return this.getBiome(x, 0, z);
    }

    @Override
    public void setBiome(int x, int z, Biome bio) {
        for (int y = this.getMinHeight(); y < this.getMaxHeight(); ++y) {
            this.setBiome(x, y, z, bio);
        }
    }

    @Override
    public void setBiome(int x, int y, int z, class_6880<class_1959> bb) {
        class_2818 chunk;
        class_2338 pos = class_2338.method_49637((double)x, (double)0.0, (double)z);
        if (this.world.method_22340(pos) && (chunk = this.world.method_8500(pos)) != null) {
            chunk.setBiome(x >> 2, y >> 2, z >> 2, bb);
            chunk.method_12008(true);
        }
    }

    @Override
    public double getTemperature(int x, int z) {
        return this.getTemperature(x, 0, z);
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
        return ((class_1959)this.world.method_16359(x >> 2, y >> 2, z >> 2).comp_349()).method_21740(pos);
    }

    @Override
    public double getHumidity(int x, int z) {
        return this.getHumidity(x, 0, z);
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        return ((class_1959)this.world.method_16359((int)(x >> 2), (int)(y >> 2), (int)(z >> 2)).comp_349()).field_26393.comp_846();
    }

    @Override
    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public Iterable<class_1297> getNMSEntities() {
        return this.getHandle().method_31592().method_31803();
    }

    @Override
    public void addEntityToWorld(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.getHandle().addFreshEntity(entity, reason);
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z) {
        return this.getNearbyEntities(location, x, y, z, null);
    }

    @Override
    public Collection<Entity> getNearbyEntities(Location location, double x, double y, double z, Predicate<Entity> filter) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((boolean)this.equals(location.getWorld()), (Object)"Location cannot be in a different world");
        BoundingBox aabb = BoundingBox.of(location, x, y, z);
        return this.getNearbyEntities(aabb, filter);
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox) {
        return this.getNearbyEntities(boundingBox, null);
    }

    @Override
    public Collection<Entity> getNearbyEntities(BoundingBox boundingBox, Predicate<Entity> filter) {
        Preconditions.checkArgument((boundingBox != null ? 1 : 0) != 0, (Object)"BoundingBox cannot be null");
        class_238 bb = new class_238(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List entityList = this.getHandle().method_8333((class_1297)null, bb, (Predicate)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        for (class_1297 entity : entityList) {
            CraftEntity bukkitEntity = entity.getBukkitEntity();
            if (filter != null && !filter.test(bukkitEntity)) continue;
            bukkitEntityList.add(bukkitEntity);
        }
        return bukkitEntityList;
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance) {
        return this.rayTraceEntities(start, direction, maxDistance, null);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize) {
        return this.rayTraceEntities(start, direction, maxDistance, raySize, null);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, Predicate<Entity> filter) {
        return this.rayTraceEntities(start, direction, maxDistance, 0.0, filter);
    }

    @Override
    public RayTraceResult rayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.equals(start.getWorld()), (Object)"Location start cannot be in a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        if (maxDistance < 0.0) {
            return null;
        }
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of(startPos, startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.getNearbyEntities(aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            BoundingBox boundingBox = entity.getBoundingBox().expand(raySize);
            RayTraceResult hitResult = boundingBox.rayTrace(startPos, direction, maxDistance);
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance) {
        return this.rayTraceBlocks(start, direction, maxDistance, FluidCollisionMode.NEVER, false);
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        return this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, false);
    }

    @Override
    public RayTraceResult rayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.equals(start.getWorld()), (Object)"Location start cannot be in a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) need to be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        class_243 startPos = CraftLocation.toVec3D(start);
        class_243 endPos = startPos.method_1031(dir.getX(), dir.getY(), dir.getZ());
        class_3965 nmsHitResult = this.getHandle().method_17742(new class_3959(startPos, endPos, ignorePassableBlocks ? class_3959.class_3960.field_17558 : class_3959.class_3960.field_17559, CraftFluidCollisionMode.toNMS(fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS(this, (class_239)nmsHitResult);
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        RayTraceResult blockHit = this.rayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = startVec.distance(blockHit.getHitPosition());
        }
        RayTraceResult entityHit = this.rayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        if (entityHitDistanceSquared < blockHitDistance * blockHitDistance) {
            return entityHit;
        }
        return blockHit;
    }

    @Override
    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>(this.world.method_18456().size());
        for (class_1657 human : this.world.method_18456()) {
            CraftHumanEntity bukkitEntity = human.getBukkitEntity();
            if (bukkitEntity == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    public void save() {
        this.server.checkSaveState();
        boolean oldSave = this.world.field_13957;
        this.world.field_13957 = false;
        this.world.method_14176(null, false, false);
        this.world.field_13957 = oldSave;
    }

    @Override
    public boolean isAutoSave() {
        return !this.world.field_13957;
    }

    @Override
    public void setAutoSave(boolean value) {
        this.world.field_13957 = !value;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().bridge$serverLevelDataCB().method_208(class_1267.method_5462((int)difficulty.getValue()));
    }

    @Override
    public Difficulty getDifficulty() {
        return Difficulty.getByValue(this.getHandle().method_8407().ordinal());
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    @Override
    public boolean hasStorm() {
        return this.world.field_9232.method_156();
    }

    @Override
    public void setStorm(boolean hasStorm) {
        this.world.field_9232.method_157(hasStorm);
        this.setWeatherDuration(0);
        this.setClearWeatherDuration(0);
    }

    @Override
    public int getWeatherDuration() {
        return this.world.field_24456.method_190();
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.world.field_24456.method_164(duration);
    }

    @Override
    public boolean isThundering() {
        return this.world.field_9232.method_203();
    }

    @Override
    public void setThundering(boolean thundering) {
        this.world.field_24456.method_147(thundering);
        this.setThunderDuration(0);
        this.setClearWeatherDuration(0);
    }

    @Override
    public int getThunderDuration() {
        return this.world.field_24456.method_145();
    }

    @Override
    public void setThunderDuration(int duration) {
        this.world.field_24456.method_173(duration);
    }

    @Override
    public boolean isClearWeather() {
        return !this.hasStorm() && !this.isThundering();
    }

    @Override
    public void setClearWeatherDuration(int duration) {
        this.world.field_24456.method_167(duration);
    }

    @Override
    public int getClearWeatherDuration() {
        return this.world.field_24456.method_155();
    }

    @Override
    public long getSeed() {
        return this.world.method_8412();
    }

    @Override
    public boolean getPVP() {
        return this.world.bridge$pvpMode();
    }

    @Override
    public void setPVP(boolean pvp) {
        this.world.banner$setPvpMode(pvp);
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Preconditions.checkArgument((effect.getData() != null ? 1 : 0) != 0, (String)"Effect.%s does not have a valid Data", (Object)((Object)effect));
            Preconditions.checkArgument((boolean)effect.getData().isAssignableFrom(data.getClass()), (String)"%s data cannot be used for the %s effect", (Object)data.getClass().getName(), (Object)((Object)effect));
        } else {
            Preconditions.checkArgument((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for the %s effect", (Object)((Object)effect));
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue, radius);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data, int radius) {
        Preconditions.checkArgument((effect != null ? 1 : 0) != 0, (Object)"Effect cannot be null");
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"World of Location cannot be null");
        int packetData = effect.getId();
        class_2673 packet = new class_2673(packetData, CraftLocation.toBlockPosition(location), data, false);
        radius *= radius;
        for (Player player : this.getPlayers()) {
            int distance;
            if (((CraftPlayer)player).getHandle().field_13987 == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
            ((CraftPlayer)player).getHandle().field_13987.method_14364((class_2596)packet);
        }
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, MaterialData data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"MaterialData cannot be null");
        return this.spawnFallingBlock(location, data.getItemType(), data.getData());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        Preconditions.checkArgument((boolean)material.isBlock(), (String)"Material.%s must be a block", (Object)material);
        class_1540 entity = BukkitExtraConstants.fall((class_1937)this.world, class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ()), CraftMagicNumbers.getBlock(material).method_9564(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, BlockData data) throws IllegalArgumentException {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        class_1540 entity = BukkitExtraConstants.fall((class_1937)this.world, class_2338.method_49637((double)location.getX(), (double)location.getY(), (double)location.getZ()), ((CraftBlockData)data).getState(), CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    @Override
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z, this, includeBiome, includeBiomeTempRain);
    }

    @Override
    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.method_8424(allowMonsters, allowAnimals);
    }

    @Override
    public boolean getAllowAnimals() {
        return this.world.method_14178().field_13941;
    }

    @Override
    public boolean getAllowMonsters() {
        return this.world.method_14178().field_13929;
    }

    @Override
    public int getMinHeight() {
        return this.world.method_31607();
    }

    @Override
    public int getMaxHeight() {
        return this.world.method_31600();
    }

    @Override
    public int getLogicalHeight() {
        return this.world.method_8597().comp_653();
    }

    @Override
    public boolean isNatural() {
        return this.world.method_8597().comp_645();
    }

    @Override
    public boolean isBedWorks() {
        return this.world.method_8597().comp_648();
    }

    @Override
    public boolean hasSkyLight() {
        return this.world.method_8597().comp_642();
    }

    @Override
    public boolean hasCeiling() {
        return this.world.method_8597().comp_643();
    }

    @Override
    public boolean isPiglinSafe() {
        return this.world.method_8597().method_44220();
    }

    @Override
    public boolean isRespawnAnchorWorks() {
        return this.world.method_8597().comp_649();
    }

    @Override
    public boolean hasRaids() {
        return this.world.method_8597().method_44221();
    }

    @Override
    public boolean isUltraWarm() {
        return this.world.method_8597().comp_644();
    }

    @Override
    public int getSeaLevel() {
        return this.world.method_8615();
    }

    @Override
    public boolean getKeepSpawnInMemory() {
        return this.world.bridge$KeepSpawnInMemory();
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.world.banner$setKeepSpawnInMemory(keepLoaded);
        class_2338 chunkcoordinates = this.world.method_43126();
        if (keepLoaded) {
            this.world.method_14178().method_17297(class_3230.field_14030, new class_1923(chunkcoordinates), 11, (Object)class_3902.field_17274);
        } else {
            this.world.method_14178().method_17300(class_3230.field_14030, new class_1923(chunkcoordinates), 11, (Object)class_3902.field_17274);
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    @Override
    public File getWorldFolder() {
        return this.world.bridge$convertable().method_27424(this.world.method_27983()).toFile();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public WorldType getWorldType() {
        return this.world.method_28125() ? WorldType.FLAT : WorldType.NORMAL;
    }

    @Override
    public boolean canGenerateStructures() {
        return this.world.bridge$serverLevelDataCB().method_28057().method_28029();
    }

    @Override
    public boolean isHardcore() {
        return this.world.method_8401().method_152();
    }

    @Override
    public void setHardcore(boolean hardcore) {
        this.world.bridge$serverLevelDataCB().field_25030.field_9262 = hardcore;
    }

    @Override
    @Deprecated
    public long getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.setTicksPerSpawns(SpawnCategory.ANIMAL, ticksPerAnimalSpawns);
    }

    @Override
    @Deprecated
    public long getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.MONSTER, ticksPerMonsterSpawns);
    }

    @Override
    @Deprecated
    public long getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public void setTicksPerWaterSpawns(int ticksPerWaterSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_ANIMAL, ticksPerWaterSpawns);
    }

    @Override
    @Deprecated
    public long getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public void setTicksPerWaterAmbientSpawns(int ticksPerWaterAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_AMBIENT, ticksPerWaterAmbientSpawns);
    }

    @Override
    @Deprecated
    public long getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public void setTicksPerWaterUndergroundCreatureSpawns(int ticksPerWaterUndergroundCreatureSpawns) {
        this.setTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE, ticksPerWaterUndergroundCreatureSpawns);
    }

    @Override
    @Deprecated
    public long getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Override
    @Deprecated
    public void setTicksPerAmbientSpawns(int ticksPerAmbientSpawns) {
        this.setTicksPerSpawns(SpawnCategory.AMBIENT, ticksPerAmbientSpawns);
    }

    @Override
    public void setTicksPerSpawns(SpawnCategory spawnCategory, int ticksPerCategorySpawn) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)((Object)spawnCategory));
        this.world.bridge$ticksPerSpawnCategory().put((Object)spawnCategory, (long)ticksPerCategorySpawn);
    }

    @Override
    public long getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)((Object)spawnCategory));
        return this.world.bridge$ticksPerSpawnCategory().getLong((Object)spawnCategory);
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public void setMonsterSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.MONSTER, limit);
    }

    @Override
    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public void setAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.ANIMAL, limit);
    }

    @Override
    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public void setWaterAnimalSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_ANIMAL, limit);
    }

    @Override
    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public void setWaterAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_AMBIENT, limit);
    }

    @Override
    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public void setWaterUndergroundCreatureSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE, limit);
    }

    @Override
    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Override
    @Deprecated
    public void setAmbientSpawnLimit(int limit) {
        this.setSpawnLimit(SpawnCategory.AMBIENT, limit);
    }

    @Override
    public int getSpawnLimit(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)((Object)spawnCategory));
        int limit = this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
        if (limit < 0) {
            limit = this.server.getSpawnLimit(spawnCategory);
        }
        return limit;
    }

    @Override
    public void setSpawnLimit(SpawnCategory spawnCategory, int limit) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)((Object)spawnCategory));
        this.spawnCategoryLimit.put((Object)spawnCategory, limit);
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        this.getHandle().method_43128(null, x, y, z, CraftSound.getSoundEffect(sound), class_3419.valueOf((String)category.name()), volume, pitch);
    }

    @Override
    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null) {
            return;
        }
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        class_2767 packet = new class_2767(class_6880.method_40223((Object)class_3414.method_47908((class_2960)new class_2960(sound))), class_3419.valueOf((String)category.name()), x, y, z, volume, pitch, this.getHandle().method_8409().method_43055());
        this.world.method_8503().method_3760().method_14605(null, x, y, z, volume > 1.0f ? (double)(16.0f * volume) : 16.0, this.world.method_27983(), (class_2596)packet);
    }

    @Override
    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    @Override
    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        class_2765 packet = new class_2765(class_7923.field_41172.method_47983((Object)CraftSound.getSoundEffect(sound)), class_3419.valueOf((String)category.name()), craftEntity.getHandle(), volume, pitch, this.getHandle().method_8409().method_43055());
        class_3898.class_3208 entityTracker = (class_3898.class_3208)this.getHandle().method_14178().field_17254.field_18242.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.method_18734((class_2596)packet);
        }
    }

    @Override
    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block5: {
            block4: {
                if (!(entity instanceof CraftEntity)) break block4;
                craftEntity = (CraftEntity)entity;
                if (entity.getWorld() == this && sound != null && category != null) break block5;
            }
            return;
        }
        class_2765 packet = new class_2765(class_6880.method_40223((Object)class_3414.method_47908((class_2960)new class_2960(sound))), class_3419.valueOf((String)category.name()), craftEntity.getHandle(), volume, pitch, this.getHandle().method_8409().method_43055());
        class_3898.class_3208 entityTracker = (class_3898.class_3208)this.getHandle().method_14178().field_17254.field_18242.get(entity.getEntityId());
        if (entityTracker != null) {
            entityTracker.method_18734((class_2596)packet);
        }
    }

    public static synchronized Map<String, class_1928.class_4313<?>> getGameRulesNMS() {
        if (gamerules != null) {
            return gamerules;
        }
        final HashMap gamerules = new HashMap();
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> gamerules_gamerulekey, class_1928.class_4314<T> gamerules_gameruledefinition) {
                gamerules.put(gamerules_gamerulekey.method_20771(), gamerules_gamerulekey);
            }
        });
        CraftWorld.gamerules = gamerules;
        return CraftWorld.gamerules;
    }

    public static synchronized Map<String, class_1928.class_4314<?>> getGameRuleDefinitions() {
        if (gameruleDefinitions != null) {
            return gameruleDefinitions;
        }
        final HashMap gameruleDefinitions = new HashMap();
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> gamerules_gamerulekey, class_1928.class_4314<T> gamerules_gameruledefinition) {
                gameruleDefinitions.put(gamerules_gamerulekey.method_20771(), gamerules_gameruledefinition);
            }
        });
        CraftWorld.gameruleDefinitions = gameruleDefinitions;
        return CraftWorld.gameruleDefinitions;
    }

    @Override
    public String getGameRuleValue(String rule) {
        if (rule == null) {
            return null;
        }
        class_1928.class_4315 value = this.getHandle().method_8450().method_20746(CraftWorld.getGameRulesNMS().get(rule));
        return value != null ? value.toString() : "";
    }

    @Override
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        class_1928.class_4315 handle = this.getHandle().method_8450().method_20746(CraftWorld.getGameRulesNMS().get(rule));
        handle.method_20777(value);
        handle.method_20778(this.getHandle().method_8503());
        return true;
    }

    @Override
    public String[] getGameRules() {
        return CraftWorld.getGameRulesNMS().keySet().toArray(new String[CraftWorld.getGameRulesNMS().size()]);
    }

    @Override
    public boolean isGameRule(String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"String rule cannot be null");
        Preconditions.checkArgument((!rule.isEmpty() ? 1 : 0) != 0, (Object)"String rule cannot be empty");
        return CraftWorld.getGameRulesNMS().containsKey(rule);
    }

    @Override
    public <T> T getGameRuleValue(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, this.getHandle().method_8450().method_20746(CraftWorld.getGameRulesNMS().get(rule.getName())));
    }

    @Override
    public <T> T getGameRuleDefault(GameRule<T> rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        return this.convert(rule, CraftWorld.getGameRuleDefinitions().get(rule.getName()).method_20773());
    }

    @Override
    public <T> boolean setGameRule(GameRule<T> rule, T newValue) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"GameRule cannot be null");
        Preconditions.checkArgument((newValue != null ? 1 : 0) != 0, (Object)"GameRule value cannot be null");
        if (!this.isGameRule(rule.getName())) {
            return false;
        }
        class_1928.class_4315 handle = this.getHandle().method_8450().method_20746(CraftWorld.getGameRulesNMS().get(rule.getName()));
        handle.method_20777(newValue.toString());
        handle.method_20778(this.getHandle().method_8503());
        return true;
    }

    private <T> T convert(GameRule<T> rule, class_1928.class_4315<?> value) {
        if (value == null) {
            return null;
        }
        if (value instanceof class_1928.class_4310) {
            return rule.getType().cast(((class_1928.class_4310)value).method_20753());
        }
        if (value instanceof class_1928.class_4312) {
            return rule.getType().cast(value.method_20781());
        }
        throw new IllegalArgumentException("Invalid GameRule type (" + value + ") for GameRule " + rule.getName());
    }

    @Override
    public WorldBorder getWorldBorder() {
        if (this.worldBorder == null) {
            this.worldBorder = new CraftWorldBorder(this);
        }
        return this.worldBorder;
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count) {
        this.spawnParticle(particle, x, y, z, count, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, T data) {
        this.spawnParticle(particle, x, y, z, count, 0.0, 0.0, 0.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    @Override
    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    public void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, null);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, x, y, z, count, offsetX, offsetY, offsetZ, extra, data, false);
    }

    @Override
    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data, force);
    }

    @Override
    public <T> void spawnParticle(Particle particle, double x, double y, double z, int count, double offsetX, double offsetY, double offsetZ, double extra, T data, boolean force) {
        if (data != null) {
            Preconditions.checkArgument((boolean)particle.getDataType().isInstance(data), (String)"data (%s) should be %s", data.getClass(), particle.getDataType());
        }
        this.getHandle().method_14199(CraftParticle.toNMS(particle, data), x, y, z, count, offsetX, offsetY, offsetZ, extra);
    }

    @Override
    @Deprecated
    public Location locateNearestStructure(Location origin, StructureType structureType, int radius, boolean findUnexplored) {
        StructureSearchResult result = null;
        if (StructureType.MINESHAFT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.MINESHAFT, radius, findUnexplored);
        } else if (StructureType.VILLAGE == structureType) {
            result = this.locateNearestStructure(origin, List.of(Structure.VILLAGE_DESERT, Structure.VILLAGE_PLAINS, Structure.VILLAGE_SAVANNA, Structure.VILLAGE_SNOWY, Structure.VILLAGE_TAIGA), radius, findUnexplored);
        } else if (StructureType.NETHER_FORTRESS == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.FORTRESS, radius, findUnexplored);
        } else if (StructureType.STRONGHOLD == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.STRONGHOLD, radius, findUnexplored);
        } else if (StructureType.JUNGLE_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.JUNGLE_TEMPLE, radius, findUnexplored);
        } else if (StructureType.OCEAN_RUIN == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_RUIN, radius, findUnexplored);
        } else if (StructureType.DESERT_PYRAMID == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.DESERT_PYRAMID, radius, findUnexplored);
        } else if (StructureType.IGLOO == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.IGLOO, radius, findUnexplored);
        } else if (StructureType.SWAMP_HUT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SWAMP_HUT, radius, findUnexplored);
        } else if (StructureType.OCEAN_MONUMENT == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.OCEAN_MONUMENT, radius, findUnexplored);
        } else if (StructureType.END_CITY == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.END_CITY, radius, findUnexplored);
        } else if (StructureType.WOODLAND_MANSION == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.WOODLAND_MANSION, radius, findUnexplored);
        } else if (StructureType.BURIED_TREASURE == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.BURIED_TREASURE, radius, findUnexplored);
        } else if (StructureType.SHIPWRECK == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.SHIPWRECK, radius, findUnexplored);
        } else if (StructureType.PILLAGER_OUTPOST == structureType) {
            result = this.locateNearestStructure(origin, Structure.PILLAGER_OUTPOST, radius, findUnexplored);
        } else if (StructureType.NETHER_FOSSIL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.NETHER_FOSSIL, radius, findUnexplored);
        } else if (StructureType.RUINED_PORTAL == structureType) {
            result = this.locateNearestStructure(origin, org.bukkit.generator.structure.StructureType.RUINED_PORTAL, radius, findUnexplored);
        } else if (StructureType.BASTION_REMNANT == structureType) {
            result = this.locateNearestStructure(origin, Structure.BASTION_REMNANT, radius, findUnexplored);
        }
        return result == null ? null : result.getLocation();
    }

    @Override
    public StructureSearchResult locateNearestStructure(Location origin, org.bukkit.generator.structure.StructureType structureType, int radius, boolean findUnexplored) {
        ArrayList<Structure> structures = new ArrayList<Structure>();
        for (Structure structure : Registry.STRUCTURE) {
            if (structure.getStructureType() != structureType) continue;
            structures.add(structure);
        }
        return this.locateNearestStructure(origin, structures, radius, findUnexplored);
    }

    @Override
    public StructureSearchResult locateNearestStructure(Location origin, Structure structure, int radius, boolean findUnexplored) {
        return this.locateNearestStructure(origin, List.of(structure), radius, findUnexplored);
    }

    @Override
    public int getViewDistance() {
        return this.world.bridge$spigotConfig().viewDistance;
    }

    @Override
    public int getSimulationDistance() {
        return this.world.bridge$spigotConfig().simulationDistance;
    }

    public StructureSearchResult locateNearestStructure(Location origin, List<Structure> structures, int radius, boolean findUnexplored) {
        class_2338 originPos = class_2338.method_49637((double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
        ArrayList<class_6880> holders = new ArrayList<class_6880>();
        for (Structure structure : structures) {
            holders.add(class_6880.method_40223((Object)CraftStructure.bukkitToMinecraft(structure)));
        }
        Pair found = this.getHandle().method_14178().method_12129().method_12103(this.getHandle(), (class_6885)class_6885.method_40242(holders), originPos, radius, findUnexplored);
        if (found == null) {
            return null;
        }
        return new CraftStructureSearchResult(CraftStructure.minecraftToBukkit((class_3195)((class_6880)found.getSecond()).comp_349(), this.getHandle().method_30349()), CraftLocation.toBukkit((class_2338)found.getFirst(), (World)this));
    }

    @Override
    public World.Spigot spigot() {
        return this.spigot;
    }

    @Override
    public Raid locateNearestRaid(Location location, int radius) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        Preconditions.checkArgument((radius >= 0 ? 1 : 0) != 0, (String)"Radius value (%s) cannot be negative", (int)radius);
        class_3767 persistentRaid = this.world.method_19495();
        class_3765 raid = persistentRaid.method_19209(CraftLocation.toBlockPosition(location), radius * radius);
        return raid == null ? null : new CraftRaid(raid);
    }

    @Override
    public List<Raid> getRaids() {
        class_3767 persistentRaid = this.world.method_19495();
        return persistentRaid.field_16639.values().stream().map(CraftRaid::new).collect(Collectors.toList());
    }

    @Override
    public DragonBattle getEnderDragonBattle() {
        return this.getHandle().method_29198() == null ? null : new CraftDragonBattle(this.getHandle().method_29198());
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    @Override
    public Set<FeatureFlag> getFeatureFlags() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().method_45162()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public void storeBukkitValues(class_2487 c) {
        if (!this.persistentDataContainer.isEmpty()) {
            c.method_10566("BukkitValues", (class_2520)this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(class_2520 c) {
        if (c instanceof class_2487) {
            this.persistentDataContainer.putAll((class_2487)c);
        }
    }

    @Override
    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type, @Nullable Predicate<BlockState> statePredicate) {
        return false;
    }
}

