/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.ban;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mojang.authlib.GameProfile;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_3330;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import org.bukkit.BanEntry;
import org.bukkit.ban.ProfileBanList;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftProfileBanEntry;
import org.bukkit.craftbukkit.v1_20_R1.profile.CraftPlayerProfile;
import org.bukkit.profile.PlayerProfile;

public class CraftProfileBanList
implements ProfileBanList {
    private final class_3335 list;

    public CraftProfileBanList(class_3335 list) {
        this.list = list;
    }

    @Override
    public BanEntry<PlayerProfile> getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(CraftProfileBanList.getProfile(target));
    }

    @Override
    public BanEntry<PlayerProfile> getBanEntry(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.getBanEntry(((CraftPlayerProfile)target).buildGameProfile());
    }

    @Override
    public BanEntry<PlayerProfile> addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        return this.addBan(CraftProfileBanList.getProfileByName(target), reason, expires, source);
    }

    @Override
    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"PlayerProfile cannot be null");
        Preconditions.checkArgument((target.getUniqueId() != null ? 1 : 0) != 0, (Object)"The PlayerProfile UUID cannot be null");
        return this.addBan(((CraftPlayerProfile)target).buildGameProfile(), reason, expires, source);
    }

    @Override
    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Instant expires, String source) {
        Date date = expires != null ? Date.from(expires) : null;
        return this.addBan(target, reason, date, source);
    }

    @Override
    public BanEntry<PlayerProfile> addBan(PlayerProfile target, String reason, Duration duration, String source) {
        Instant instant = duration != null ? Instant.now().plus(duration) : null;
        return this.addBan(target, reason, instant, source);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_3336 entry : this.list.method_14632()) {
            GameProfile profile = (GameProfile)entry.method_14626();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    @Override
    public Set<BanEntry<PlayerProfile>> getEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_3336 entry : this.list.method_14632()) {
            GameProfile profile = (GameProfile)entry.method_14626();
            builder.add((Object)new CraftProfileBanEntry(profile, entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(((CraftPlayerProfile)target).buildGameProfile());
    }

    @Override
    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.isBanned(CraftProfileBanList.getProfile(target));
    }

    @Override
    public void pardon(PlayerProfile target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(((CraftPlayerProfile)target).buildGameProfile());
    }

    @Override
    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.pardon(CraftProfileBanList.getProfile(target));
    }

    @Override
    public BanEntry<PlayerProfile> getBanEntry(GameProfile profile) {
        if (profile == null) {
            return null;
        }
        class_3336 entry = (class_3336)this.list.method_14640((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry<PlayerProfile> addBan(GameProfile profile, String reason, Date expires, String source) {
        if (profile == null) {
            return null;
        }
        class_3336 entry = new class_3336(profile, new Date(), source == null || source.isBlank() ? null : source, expires, reason == null || reason.isBlank() ? null : reason);
        this.list.method_14633((class_3330)entry);
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    private void pardon(GameProfile profile) {
        this.list.method_14635((Object)profile);
    }

    @Override
    private boolean isBanned(GameProfile profile) {
        return profile != null && this.list.method_14650(profile);
    }

    static GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return uuid != null ? CraftProfileBanList.getProfileByUUID(uuid) : CraftProfileBanList.getProfileByName(target);
    }

    static GameProfile getProfileByUUID(UUID uuid) {
        return BukkitExtraConstants.getServer() != null ? (GameProfile)BukkitExtraConstants.getServer().method_3793().method_14512(uuid).orElse(null) : null;
    }

    static GameProfile getProfileByName(String name) {
        return BukkitExtraConstants.getServer() != null ? (GameProfile)BukkitExtraConstants.getServer().method_3793().method_14515(name).orElse(null) : null;
    }
}

