/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.bukkit.PluginsLibrarySource;
import com.mohistmc.banner.bukkit.remapping.RemappingURLClassLoader;
import com.mohistmc.banner.util.I18n;
import com.mohistmc.mjson.Json;
import com.mohistmc.tools.ConnectionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryLoader {
    public static Set<File> libraries = new HashSet<File>();
    public static Set<Dependency> newDependencies = new HashSet<Dependency>();
    public static Set<DependencyIgnoreVersion> dependencyIgnoreVersion = new HashSet<DependencyIgnoreVersion>();

    @Nullable
    public ClassLoader createLoader(@NotNull PluginDescriptionFile desc) {
        String fileName;
        String group;
        if (desc.getLibraries().isEmpty()) {
            return null;
        }
        BannerServer.LOGGER.info(I18n.as("spigot.lib.loading"), (Object)desc.getName(), (Object)desc.getLibraries().size());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (String string : desc.getLibraries()) {
            Dependency dependency;
            String[] args = string.split(":");
            if (args.length <= 1 || this.has(dependency = new Dependency(args[0], args[1], args[2], false))) continue;
            dependencies.add(dependency);
        }
        List<String> d = this.mohistLibs();
        for (Dependency dependency : dependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            if (d.contains(fileName)) continue;
            if (dependency.version().equalsIgnoreCase("LATEST")) {
                newDependencies.add(this.findDependency(group, dependency.name(), false));
                continue;
            }
            newDependencies.add(dependency);
            String pomUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName.replace("jar", "pom"));
            if (!ConnectionUtil.isValid((String)pomUrl)) continue;
            newDependencies.addAll(this.initDependencies0(pomUrl));
        }
        BannerServer.LOGGER.info(I18n.as("spigot.lib.loading.extra"), (Object)desc.getName(), (Object)(newDependencies.size() - desc.getLibraries().size()));
        for (Dependency dependency : newDependencies) {
            group = dependency.group().replace(".", "/");
            fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
            String mavenUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            File file = new File(new File("libraries", "spigot-lib"), "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName));
            if (this.has(dependency)) continue;
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                InputStream inputStream = new URL(mavenUrl).openStream();
                ReadableByteChannel rbc = Channels.newChannel(inputStream);
                FileChannel fc = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
                fc.close();
                rbc.close();
                libraries.add(file);
            }
            catch (IOException e) {
                BannerServer.LOGGER.error(e.getMessage());
            }
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : libraries) {
            try {
                arrayList.add(file.toURI().toURL());
                BannerServer.LOGGER.info(I18n.as("spigot.lib.loaded"), (Object)desc.getName(), (Object)file);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return new RemappingURLClassLoader(arrayList.toArray(new URL[0]), this.getClass().getClassLoader());
    }

    public Set<Dependency> initDependencies0(String url) {
        HashSet<Dependency> list = new HashSet<Dependency>();
        for (Dependency dependency : this.initDependencies(url)) {
            if (newDependencies.contains(dependency)) continue;
            list.add(dependency);
            if (dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) continue;
            dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            if (!dependency.extra()) continue;
            String group = dependency.group().replace(".", "/");
            String fileName = "%s-%s.pom".formatted(dependency.name(), dependency.version());
            String pomUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name(), dependency.version(), fileName);
            if (!ConnectionUtil.isValid((String)pomUrl)) continue;
            list.addAll(this.initDependencies(pomUrl));
        }
        return list;
    }

    public Set<Dependency> initDependencies(String url) {
        Json json2Json;
        HashSet<Dependency> list = new HashSet<Dependency>();
        Json json = Json.readXml((String)url);
        if (json != null && (json2Json = json.at("project")) != null) {
            String groupId;
            String version = json2Json.has("parent") ? json2Json.at("parent").asString("version") : json2Json.asString("version");
            String string = groupId = json2Json.has("parent") ? json2Json.at("parent").asString("groupId") : json2Json.asString("groupId");
            if (!json2Json.has("dependencies")) {
                return list;
            }
            if (!json2Json.at("dependencies").toString().startsWith("{\"dependency\"")) {
                return list;
            }
            Json json3Json = json2Json.at("dependencies").at("dependency");
            if (json3Json.isArray()) {
                for (Json o : json2Json.at("dependencies").asJsonList("dependency")) {
                    this.dependency(o, list, version, groupId);
                }
            } else {
                this.dependency(json3Json, list, version, groupId);
            }
            list.addAll(this.findDependency(list));
        }
        return list;
    }

    public void dependency(Json json, Set<Dependency> list, String version, String parent_groupId) {
        try {
            if (json.toString().contains("groupId") && json.toString().contains("artifactId")) {
                String artifactId;
                DependencyIgnoreVersion d;
                String groupId = json.asString("groupId");
                if (groupId.startsWith("${")) {
                    groupId = parent_groupId;
                }
                if (dependencyIgnoreVersion.contains(d = new DependencyIgnoreVersion(groupId, artifactId = json.asString("artifactId")))) {
                    return;
                }
                if (json.has("optional")) {
                    return;
                }
                if (json.has("scope") && (json.asString("scope").equals("test") || json.asString("scope").equals("provided"))) {
                    return;
                }
                if (json.toString().contains("version")) {
                    String versionAsString = json.asString("version");
                    if (versionAsString.contains("${project.version}") || versionAsString.contains("${project.parent.version}")) {
                        Dependency dependency = new Dependency(groupId, artifactId, version, true);
                        list.add(dependency);
                    } else if (!versionAsString.contains("${")) {
                        Dependency dependency = new Dependency(groupId, artifactId, versionAsString, true);
                        list.add(dependency);
                    }
                } else if (json.has("scope") && json.asString("scope").equals("compile")) {
                    list.add(this.findDependency(groupId, artifactId, true));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Dependency findDependency(String groupId, String artifactId, boolean extra) {
        String mavenUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s".formatted(groupId.replace(".", "/"), artifactId, "maven-metadata.xml");
        Json compile_json2Json = Json.readXml((String)mavenUrl).at("metadata");
        List v = compile_json2Json.at("versioning").at("versions").at("version").asList();
        return new Dependency(groupId, artifactId, (String)v.get(v.size() - 1), extra);
    }

    public Set<Dependency> findDependency(Set<Dependency> dependencySet) {
        HashSet<Dependency> list = new HashSet<Dependency>();
        for (Dependency dependency : dependencySet) {
            if (dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) continue;
            dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            String group = dependency.group.replace(".", "/");
            String fileName = "%s-%s.pom".formatted(dependency.name, dependency.version);
            String pomUrl = PluginsLibrarySource.DEFAULT + "%s/%s/%s/%s".formatted(group, dependency.name, dependency.version, fileName);
            if (!ConnectionUtil.isValid((String)pomUrl)) continue;
            list.addAll(this.initDependencies(pomUrl));
        }
        return list;
    }

    public boolean has(Dependency dependency) {
        String fileName = "%s-%s.jar".formatted(dependency.name(), dependency.version());
        File file = new File(new File("libraries", "plugins-lib"), "%s/%s/%s/%s".formatted(dependency.group, dependency.name, dependency.version(), fileName));
        if (file.exists() && !dependencyIgnoreVersion.contains(dependency.toIgnoreVersion())) {
            libraries.add(file);
            dependencyIgnoreVersion.add(dependency.toIgnoreVersion());
            BannerServer.LOGGER.info(I18n.as("spigot.lib.found"), (Object)dependency.name, (Object)file);
            return true;
        }
        return false;
    }

    public List<String> mohistLibs() {
        ArrayList<String> temp = new ArrayList<String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(LibraryLoader.class.getClassLoader().getResourceAsStream("libraries.txt")));
        try {
            String str;
            while ((str = b.readLine()) != null) {
                String[] s = str.split("\\|");
                temp.add(new File(s[0]).getName());
            }
            b.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return temp;
    }

    public record Dependency(String group, String name, String version, boolean extra) {
        public DependencyIgnoreVersion toIgnoreVersion() {
            return new DependencyIgnoreVersion(this.group, this.name);
        }
    }

    public record DependencyIgnoreVersion(String group, String name) {
    }
}

