/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.pluginfix;

import com.mohistmc.banner.bukkit.pluginfix.MultiverseCore;
import com.mohistmc.banner.bukkit.pluginfix.WorldEdit;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PluginFixManager {
    public static byte[] injectPluginFix(String className, byte[] clazz) {
        if (className.endsWith("PaperLib")) {
            return PluginFixManager.patch(clazz, PluginFixManager::removePaper);
        }
        if (className.equals("com.onarandombox.MultiverseCore.utils.WorldManager")) {
            return PluginFixManager.patch(clazz, MultiverseCore::fix);
        }
        Consumer<ClassNode> patcher = switch (className) {
            case "com.sk89q.worldedit.bukkit.BukkitAdapter" -> WorldEdit::handleBukkitAdapter;
            case "com.sk89q.worldedit.bukkit.adapter.Refraction" -> WorldEdit::handlePickName;
            case "com.earth2me.essentials.utils.VersionUtil" -> node -> PluginFixManager.helloWorld(node, 110, 109);
            case "net.ess3.nms.refl.providers.ReflServerStateProvider" -> node -> PluginFixManager.helloWorld(node, "u", "U");
            case "net.Zrips.CMILib.Reflections" -> node -> PluginFixManager.helloWorld(node, "bR", "field_7512");
            default -> null;
        };
        return patcher == null ? clazz : PluginFixManager.patch(clazz, patcher);
    }

    private static byte[] patch(byte[] basicClass, Consumer<ClassNode> handler) {
        ClassNode node = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)node, 0);
        handler.accept(node);
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private static void removePaper(ClassNode node) {
        for (MethodNode methodNode : node.methods) {
            if (!methodNode.name.equals("isPaper") || !methodNode.desc.equals("()Z")) continue;
            InsnList toInject = new InsnList();
            toInject.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(PluginFixManager.class), "isPaper", "()Z"));
            toInject.add((AbstractInsnNode)new InsnNode(172));
            methodNode.instructions = toInject;
        }
    }

    public static boolean isPaper() {
        return false;
    }

    private static void helloWorld(ClassNode node, String a, String b) {
        node.methods.forEach(method -> {
            for (AbstractInsnNode next : method.instructions) {
                String str;
                if (!(next instanceof LdcInsnNode)) continue;
                LdcInsnNode ldcInsnNode = (LdcInsnNode)next;
                Object patt2816$temp = ldcInsnNode.cst;
                if (!(patt2816$temp instanceof String) || !a.equals(str = (String)patt2816$temp)) continue;
                ldcInsnNode.cst = b;
            }
        });
    }

    private static void helloWorld(ClassNode node, int a, int b) {
        node.methods.forEach(method -> {
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof IntInsnNode)) continue;
                IntInsnNode ldcInsnNode = (IntInsnNode)next;
                if (ldcInsnNode.operand != a) continue;
                ldcInsnNode.operand = b;
            }
        });
    }
}

