/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.command;

import com.mohistmc.banner.api.ItemAPI;
import com.mohistmc.banner.api.PlayerAPI;
import com.mohistmc.banner.util.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.minecraft.class_1799;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemsCommand
extends Command {
    private final List<String> params = Arrays.asList("info", "name");

    public ItemsCommand(String name) {
        super(name);
        this.description = I18n.as("itemscmd.description");
        this.usageMessage = "/items [info|name]";
        this.setPermission("mohist.command.items");
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + I18n.as("error.notplayer"));
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "info": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(ChatColor.RED + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                ItemsCommand.info(player);
                return true;
            }
            case "name": {
                if (itemStack == null || itemStack.getType().isAir()) {
                    player.sendMessage(ChatColor.RED + I18n.as("itemscmd.mainhandEmpty"));
                    return false;
                }
                if (args.length != 2) {
                    sender.sendMessage(ChatColor.RED + "Usage: /items name <string>");
                    return false;
                }
                ItemAPI.name(player.getInventory().getItemInMainHand(), args[1]);
                sender.sendMessage(ChatColor.GREEN + "Item name set complete.");
                return true;
            }
        }
        sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
        return false;
    }

    public static void info(Player player) {
        ItemStack itemStack = player.getInventory().getItemInMainHand();
        class_1799 nmsItem = CraftItemStack.asNMSCopy(itemStack);
        ItemsCommand.sendMessageByCopy(player, ChatColor.GRAY + "Type - ", itemStack.getType().name());
        player.sendMessage(ChatColor.GRAY + "Name - %s".formatted(nmsItem.method_7964().getString()));
        player.sendMessage(ChatColor.GRAY + "FabricItem - %s".formatted(itemStack.getType().isFabricItem));
        player.sendMessage(ChatColor.GRAY + "FabricBlock - %s".formatted(itemStack.getType().isFabricBlock));
        ItemsCommand.sendMessageByCopy(player, ChatColor.GRAY + "NBT(CraftBukkit) - ", ItemAPI.getNBTAsString(itemStack));
        ItemsCommand.sendMessageByCopy(player, ChatColor.GRAY + "NBT(Vanilla) - ", ItemAPI.getNbtAsString(PlayerAPI.getNMSPlayer(player).method_6047().method_7969()));
    }

    public static void sendMessageByCopy(Player player, String des, String info) {
        TextComponent textComponent = new TextComponent(des + info);
        textComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder("\u00a7c%s".formatted(I18n.as("itemscmd.copy"))).create()));
        textComponent.setClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, info));
        player.spigot().sendMessage((BaseComponent)textComponent);
    }
}

