/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.mohistmc.banner.BannerMCStart;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BannerMixinPlugin
implements IMixinConfigPlugin {
    private final Map<String, Map.Entry<List<FieldNode>, List<MethodNode>>> accessTransformer = ImmutableMap.builder().put((Object)"net.minecraft.world.item.BoneMealItem", (Object)Maps.immutableEntry((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)new MethodNode(9, "applyBonemeal", "(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;", null, null)))).put((Object)"net.minecraft.world.level.block.DispenserBlock", (Object)Maps.immutableEntry((Object)ImmutableList.of((Object)new FieldNode(13, "eventFired", "Z", null, null)), (Object)ImmutableList.of())).put((Object)"net.minecraft.world.item.SignItem", (Object)Maps.immutableEntry((Object)ImmutableList.of((Object)new FieldNode(13, "openSign", "Lnet/minecraft/core/BlockPos;", null, null)), (Object)ImmutableList.of())).put((Object)"net.minecraft.network.chat.ChatType", (Object)Maps.immutableEntry((Object)ImmutableList.of((Object)new FieldNode(25, "RAW", "Lnet/minecraft/resources/ResourceKey;", null, null)), (Object)ImmutableList.of())).put((Object)"net.minecraft.world.level.block.ComposterBlock", (Object)Maps.immutableEntry((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)new MethodNode(9, "addItem", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/item/ItemStack;D)Lnet/minecraft/world/level/block/state/BlockState;", null, null)))).put((Object)"net.minecraft.server.commands.ReloadCommand", (Object)Maps.immutableEntry((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)new MethodNode(9, "reload", "(Lnet/minecraft/server/MinecraftServer;)V", null, null)))).put((Object)"net.minecraft.server.MinecraftServer", (Object)Maps.immutableEntry((Object)ImmutableList.of((Object)new FieldNode(9, "currentTick", "I", null, null)), (Object)ImmutableList.of((Object)new MethodNode(9, "getServer", "()Lnet/minecraft/server/MinecraftServer;", null, null)))).put((Object)"net.minecraft.world.item.LeadItem", (Object)Maps.immutableEntry((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)new MethodNode(9, "bindPlayerMobs", "Lnet/minecraft/world/InteractionResult;", "Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/InteractionHand;", null)))).put((Object)"net.minecraft.server.level.TicketType", (Object)Maps.immutableEntry((Object)ImmutableList.of((Object)new FieldNode(25, "PLUGIN", "Lnet/minecraft/server/level/TicketType;", null, null), (Object)new FieldNode(25, "PLUGIN_TICKET", "Lnet/minecraft/server/level/TicketType;", null, null)), (Object)ImmutableList.of())).build();
    private final Set<String> modifyConstructor = ImmutableSet.builder().add((Object)"net.minecraft.class_1937").add((Object)"net.minecraft.class_3218").add((Object)"net.minecraft.class_1277").add((Object)"net.minecraft.class_3962").add((Object)"net.minecraft.class_3962$class_3925").add((Object)"net.minecraft.class_1702").add((Object)"net.minecraft.class_8566").add((Object)"net.minecraft.class_1730").add((Object)"net.minecraft.class_1914").add((Object)"net.minecraft.class_3916").add((Object)"net.minecraft.class_3231").add((Object)"net.minecraft.class_2815").add((Object)"net.minecraft.class_5251").add((Object)"net.minecraft.class_2170").add((Object)"net.minecraft.class_32$class_5143").add((Object)"net.minecraft.class_7439").add((Object)"net.minecraft.class_2637").add((Object)"net.minecraft.class_3320").add((Object)"net.minecraft.class_2347").add((Object)"net.minecraft.class_2897").add((Object)"net.minecraft.class_3350").add((Object)"net.minecraft.class_2826").build();

    public void onLoad(String mixinPackage) {
        try {
            BannerMCStart.run();
        }
        catch (Exception ex) {
            BannerMCStart.LOGGER.error("Failed to load BannerServer..., caused by " + ex.getCause());
            throw new RuntimeException(ex);
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.equals("com.mohistmc.banner.mixin.world.entity.MixinMob$PaperSpawnAffect")) {
            return !FabricLoader.getInstance().isModLoaded("vmp");
        }
        if (mixinClassName.equals("com.mohistmc.banner.mixin.world.level.spawner.MixinNaturalSpawner")) {
            return !FabricLoader.getInstance().isModLoaded("carpet-tis-addition") && !FabricLoader.getInstance().isModLoaded("carpet");
        }
        if (mixinClassName.equals("com.mohistmc.banner.mixin.network.protocol.MixinPacketUtils")) {
            return !FabricLoader.getInstance().isModLoaded("cobblemon");
        }
        if (mixinClassName.equals("com.mohistmc.banner.mixin.world.item.MixinChorusFruitItem")) {
            return !FabricLoader.getInstance().isModLoaded("openpartiesandclaims");
        }
        if (mixinClassName.equals("com.mohistmc.banner.mixin.world.level.MixinClipContext")) {
            return !FabricLoader.getInstance().isModLoaded("create") && !FabricLoader.getInstance().isModLoaded("porting_lib");
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        Map.Entry<List<FieldNode>, List<MethodNode>> entry = this.accessTransformer.get(targetClassName);
        if (entry != null) {
            List<FieldNode> fields = entry.getKey();
            for (FieldNode fieldNode : targetClass.fields) {
                this.tryTransform(fields, fieldNode);
            }
            List<MethodNode> methods = entry.getValue();
            for (MethodNode methodNode : targetClass.methods) {
                this.tryTransform(methods, methodNode);
            }
        }
        this.modifyConstructor(targetClassName, targetClass);
    }

    private void modifyConstructor(String targetClassName, ClassNode classNode) {
        if (this.modifyConstructor.contains(targetClassName)) {
            HashSet<String> presentCtor = new HashSet<String>();
            HashSet<String> overrideCtor = new HashSet<String>();
            for (MethodNode method : classNode.methods) {
                if (method.name.equals("<init>")) {
                    presentCtor.add(method.desc);
                }
                if (!method.name.equals("banner$constructor$override")) continue;
                overrideCtor.add(method.desc);
            }
            ListIterator iterator = classNode.methods.listIterator();
            while (iterator.hasNext()) {
                MethodNode methodNode = (MethodNode)iterator.next();
                if (methodNode.name.equals("banner$constructor")) {
                    String desc = methodNode.desc;
                    if (presentCtor.contains(desc)) {
                        iterator.remove();
                    } else {
                        methodNode.name = "<init>";
                        presentCtor.add(methodNode.desc);
                        this.remapCtor(classNode, methodNode);
                    }
                }
                if (methodNode.name.equals("banner$constructor$super")) {
                    iterator.remove();
                }
                if (methodNode.name.equals("<init>") && overrideCtor.contains(methodNode.desc)) {
                    iterator.remove();
                    continue;
                }
                if (!methodNode.name.equals("banner$constructor$override")) continue;
                methodNode.name = "<init>";
                this.remapCtor(classNode, methodNode);
            }
        }
    }

    private void remapCtor(ClassNode classNode, MethodNode methodNode) {
        boolean initialized = false;
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof MethodInsnNode)) continue;
            MethodInsnNode methodInsnNode = (MethodInsnNode)node;
            if (methodInsnNode.name.equals("banner$constructor")) {
                if (initialized) {
                    throw new ClassFormatError("Duplicate constructor call");
                }
                methodInsnNode.setOpcode(183);
                methodInsnNode.name = "<init>";
                initialized = true;
            }
            if (!methodInsnNode.name.equals("banner$constructor$super")) continue;
            if (initialized) {
                throw new ClassFormatError("Duplicate constructor call");
            }
            methodInsnNode.setOpcode(183);
            methodInsnNode.owner = classNode.superName;
            methodInsnNode.name = "<init>";
            initialized = true;
        }
        if (!initialized) {
            if (classNode.superName.equals("java/lang/Object")) {
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
                methodNode.instructions.insert(insnList);
            } else {
                throw new ClassFormatError("No super constructor call present: " + classNode.name);
            }
        }
    }

    private void tryTransform(List<FieldNode> fields, FieldNode fieldNode) {
        for (FieldNode field : fields) {
            if (!Objects.equals(fieldNode.name, field.name) || !Objects.equals(fieldNode.desc, field.desc)) continue;
            fieldNode.access = field.access;
        }
    }

    private void tryTransform(List<MethodNode> methods, MethodNode methodNode) {
        for (MethodNode method : methods) {
            if (!Objects.equals(methodNode.name, method.name) || !Objects.equals(methodNode.desc, method.desc)) continue;
            methodNode.access = method.access;
        }
    }
}

