/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.mixin.server.dedicated;

import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.Metrics;
import com.mohistmc.banner.config.BannerConfig;
import com.mohistmc.banner.util.I18n;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Handler;
import java.util.logging.Logger;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2976;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3283;
import net.minecraft.class_3350;
import net.minecraft.class_3950;
import net.minecraft.class_6904;
import net.minecraft.class_7497;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.io.IoBuilder;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.util.ForwardLogHandler;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.spigotmc.SpigotConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3176.class})
public abstract class MixinDedicatedServer
extends MinecraftServer {
    @Unique
    public AtomicReference<class_3350> rconConsoleSource = new AtomicReference<Object>(null);

    public MixinDedicatedServer(Thread thread, class_32.class_5143 levelStorageAccess, class_3283 packRepository, class_6904 worldStem, Proxy proxy, DataFixer dataFixer, class_7497 services, class_3950 chunkProgressListenerFactory) {
        super(thread, levelStorageAccess, packRepository, worldStem, proxy, dataFixer, services, chunkProgressListenerFactory);
    }

    @Inject(method={"initServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/dedicated/DedicatedServer;usesAuthentication()Z", ordinal=1)})
    private void banner$initServer(CallbackInfoReturnable<Boolean> cir) {
        BannerServer.LOGGER.info(I18n.as("bukkit.plugin.loading.info"));
        SpigotConfig.init((File)this.bridge$options().valueOf("spigot-settings"));
        BannerConfig.init((File)this.bridge$options().valueOf("banner-settings"));
        if (BannerConfig.motdEnable) {
            this.method_3834(BannerConfig.motd());
        }
        SpigotConfig.registerCommands();
        this.bridge$server().loadPlugins();
        this.bridge$server().enablePlugins(PluginLoadOrder.STARTUP);
    }

    @Inject(method={"initServer"}, at={@At(value="INVOKE", target="Ljava/lang/Thread;setDaemon(Z)V", ordinal=0, shift=At.Shift.BEFORE)})
    private void banner$addLog4j(CallbackInfoReturnable<Boolean> cir) {
        Logger global = Logger.getLogger("");
        global.setUseParentHandlers(false);
        for (Handler handler : global.getHandlers()) {
            global.removeHandler(handler);
        }
        global.addHandler(new ForwardLogHandler());
        org.apache.logging.log4j.Logger logger = LogManager.getRootLogger();
        System.setOut(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger((org.apache.logging.log4j.Logger)logger).setLevel(Level.WARN).buildPrintStream());
    }

    @Inject(method={"getPluginNames"}, at={@At(value="RETURN")}, cancellable=true)
    private void banner$setPluginNames(CallbackInfoReturnable<String> cir) {
        StringBuilder result = new StringBuilder();
        Plugin[] plugins = this.bridge$server().getPluginManager().getPlugins();
        result.append(this.bridge$server().getName());
        result.append(" on Bukkit ");
        result.append(this.bridge$server().getBukkitVersion());
        if (plugins.length > 0 && this.bridge$server().getQueryPlugins()) {
            result.append(": ");
            for (int i = 0; i < plugins.length; ++i) {
                if (i > 0) {
                    result.append("; ");
                }
                result.append(plugins[i].getDescription().getName());
                result.append(" ");
                result.append(plugins[i].getDescription().getVersion().replaceAll(";", ","));
            }
        }
        cir.setReturnValue((Object)result.toString());
    }

    @Redirect(method={"handleConsoleInputs"}, at=@At(value="INVOKE", target="Lnet/minecraft/commands/Commands;performPrefixedCommand(Lnet/minecraft/commands/CommandSourceStack;Ljava/lang/String;)I"))
    private int banner$serverCommandEvent(class_2170 commands, class_2168 source, String command) {
        if (command.isEmpty()) {
            return 0;
        }
        ServerCommandEvent event = new ServerCommandEvent(this.bridge$console(), command);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            this.bridge$server().dispatchServerCommand(this.bridge$console(), new class_2976(event.getCommand(), source));
        }
        return 0;
    }

    public void banner$setRconConsoleSource(class_3350 source) {
        this.rconConsoleSource.set(source);
    }

    @Overwrite
    public String method_12934(String command) {
        class_3350 rconConsoleSource1 = this.rconConsoleSource.get();
        rconConsoleSource1.method_14702();
        this.method_19537(() -> {
            class_2168 wrapper = rconConsoleSource1.method_14700();
            RemoteServerCommandEvent event = new RemoteServerCommandEvent(rconConsoleSource1.getBukkitSender(wrapper), command);
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                return;
            }
            class_2976 serverCommand = new class_2976(event.getCommand(), wrapper);
            this.bridge$server().dispatchServerCommand(event.getSender(), serverCommand);
        });
        return rconConsoleSource1.method_14701();
    }

    @Inject(method={"onServerExit"}, at={@At(value="RETURN")})
    public void banner$exitNow(CallbackInfo ci) {
        Thread exitThread = new Thread(this::banner$exit, "Exit Thread");
        exitThread.setDaemon(true);
        exitThread.start();
    }

    @Unique
    private void banner$exit() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<String> threads = new ArrayList<String>();
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (thread.isDaemon() || thread.getName().equals("DestroyJavaVM")) continue;
            threads.add(thread.getName());
        }
        if (!threads.isEmpty()) {
            BannerServer.LOGGER.debug("Threads {} not shutting down", (Object)String.join((CharSequence)", ", threads));
            BannerServer.LOGGER.info("{} threads not shutting down correctly, force exiting", (Object)threads.size());
        }
        System.exit(0);
    }

    @Inject(method={"showGui"}, at={@At(value="HEAD")}, cancellable=true)
    public void banner$cancelGui(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"initServer"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;info(Ljava/lang/String;Ljava/lang/Object;)V", remap=false, ordinal=3, shift=At.Shift.AFTER)})
    private void banner$startMetrics(CallbackInfoReturnable<Boolean> cir) {
        Metrics.BannerMetrics.startMetrics();
    }
}

