/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.network.download;

import com.mohistmc.banner.config.BannerConfigUtil;
import com.mohistmc.tools.ConnectionUtil;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    GITHUB("https://mohistmc.github.io/maven/");

    public final String url;

    public static DownloadSource get() {
        String ds = BannerConfigUtil.defaultSource();
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            if (!ConnectionUtil.canAccess((String)me.url)) {
                return GITHUB;
            }
            return me;
        }
        return MOHIST;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }
}

