/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_2338;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.projectiles.ProjectileSource;

public class CraftArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftArrow(CraftServer server, class_1665 entity) {
        super(server, (class_1297)entity);
    }

    @Override
    public void setKnockbackStrength(int knockbackStrength) {
        Preconditions.checkArgument((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback value (%s) cannot be negative", (int)knockbackStrength);
        this.getHandle().method_7449(knockbackStrength);
    }

    @Override
    public int getKnockbackStrength() {
        return this.getHandle().field_7575;
    }

    @Override
    public double getDamage() {
        return this.getHandle().method_7448();
    }

    @Override
    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().method_7438(damage);
    }

    @Override
    public int getPierceLevel() {
        return this.getHandle().method_7447();
    }

    @Override
    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((0 <= pierceLevel && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().method_7451((byte)pierceLevel);
    }

    @Override
    public boolean isCritical() {
        return this.getHandle().method_7443();
    }

    @Override
    public void setCritical(boolean critical) {
        this.getHandle().method_7439(critical);
    }

    @Override
    public ProjectileSource getShooter() {
        return this.getHandle().bridge$projectileSource();
    }

    @Override
    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().method_7432(((CraftEntity)((Object)shooter)).getHandle());
        } else {
            this.getHandle().method_7432(null);
        }
        this.getHandle().banner$setProjectileSource(shooter);
    }

    @Override
    public boolean isInBlock() {
        return this.getHandle().field_7588;
    }

    @Override
    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        class_2338 pos = this.getHandle().method_24515();
        return this.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Override
    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().field_7572.ordinal()];
    }

    @Override
    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().field_7572 = class_1665.class_1666.method_7458((int)status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().field_7578 = value;
    }

    @Override
    public boolean isShotFromCrossbow() {
        return this.getHandle().method_7456();
    }

    @Override
    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.getHandle().method_7442(shotFromCrossbow);
    }

    public class_1665 getHandle() {
        return (class_1665)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }
}

