/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.generator;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2839;
import net.minecraft.class_5281;
import net.minecraft.class_6880;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftRegionAccessor;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftLimitedRegion
extends CraftRegionAccessor
implements LimitedRegion {
    private final WeakReference<class_5281> weakAccess;
    private final int centerChunkX;
    private final int centerChunkZ;
    private final int buffer = 16;
    private final BoundingBox region;
    boolean entitiesLoaded = false;
    private final List<class_1297> entities = new ArrayList<class_1297>();
    private final List<class_1297> outsideEntities = new ArrayList<class_1297>();

    public CraftLimitedRegion(class_5281 access, class_1923 center) {
        this.weakAccess = new WeakReference<class_5281>(access);
        this.centerChunkX = center.field_9181;
        this.centerChunkZ = center.field_9180;
        CraftWorld world = access.getMinecraftWorld().getWorld();
        int xCenter = this.centerChunkX << 4;
        int zCenter = this.centerChunkZ << 4;
        int xMin = xCenter - this.getBuffer();
        int zMin = zCenter - this.getBuffer();
        int xMax = xCenter + this.getBuffer() + 16;
        int zMax = zCenter + this.getBuffer() + 16;
        this.region = new BoundingBox(xMin, world.getMinHeight(), zMin, xMax, world.getMaxHeight(), zMax);
    }

    @Override
    public class_5281 getHandle() {
        class_5281 handle = (class_5281)this.weakAccess.get();
        Preconditions.checkState((handle != null ? 1 : 0) != 0, (Object)"GeneratorAccessSeed no longer present, are you using it in a different tick?");
        return handle;
    }

    public void loadEntities() {
        if (this.entitiesLoaded) {
            return;
        }
        class_5281 access = this.getHandle();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2839 chunk = (class_2839)access.method_8392(this.centerChunkX + x, this.centerChunkZ + z);
                for (class_2487 compound : chunk.method_12295()) {
                    class_1299.method_17842((class_2487)compound, (class_1937)access.getMinecraftWorld(), entity -> {
                        if (this.region.contains(entity.method_23317(), entity.method_23318(), entity.method_23321())) {
                            entity.banner$setGeneration(true);
                            this.entities.add((class_1297)entity);
                        } else {
                            this.outsideEntities.add((class_1297)entity);
                        }
                        return entity;
                    });
                }
            }
        }
        this.entitiesLoaded = true;
    }

    public void saveEntities() {
        class_5281 access = this.getHandle();
        if (this.entitiesLoaded) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    class_2839 chunk = (class_2839)access.method_8392(this.centerChunkX + x, this.centerChunkZ + z);
                    chunk.method_12295().clear();
                }
            }
        }
        for (class_1297 entity : this.entities) {
            if (!entity.method_5805()) continue;
            Preconditions.checkState((boolean)this.region.contains(entity.method_23317(), entity.method_23318(), entity.method_23321()), (String)"Entity %s is not in the region", (Object)entity);
            access.method_8649(entity);
        }
        for (class_1297 entity : this.outsideEntities) {
            access.method_8649(entity);
        }
    }

    public void breakLink() {
        this.weakAccess.clear();
    }

    @Override
    public int getBuffer() {
        return 16;
    }

    @Override
    public boolean isInRegion(Location location) {
        return this.region.contains(location.getX(), location.getY(), location.getZ());
    }

    @Override
    public boolean isInRegion(int x, int y, int z) {
        return this.region.contains(x, y, z);
    }

    @Override
    public List<BlockState> getTileEntities() {
        ArrayList<BlockState> blockStates = new ArrayList<BlockState>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2839 chunk = (class_2839)this.getHandle().method_8392(this.centerChunkX + x, this.centerChunkZ + z);
                for (class_2338 position : chunk.method_12021()) {
                    blockStates.add(this.getBlockState(position.method_10263(), position.method_10264(), position.method_10260()));
                }
            }
        }
        return blockStates;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBiome(x, y, z);
    }

    @Override
    public void setBiome(int x, int y, int z, class_6880<class_1959> biomeBase) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        class_2791 chunk = this.getHandle().method_22342(x >> 4, z >> 4, class_2806.field_12798);
        chunk.setBiome(x >> 2, y >> 2, z >> 2, biomeBase);
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBlockState(x, y, z);
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getBlockData(x, y, z);
    }

    @Override
    public Material getType(int x, int y, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        return super.getType(x, y, z);
    }

    @Override
    public void setBlockData(int x, int y, int z, BlockData blockData) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, y, z), (String)"Coordinates %s, %s, %s are not in the region", (Object)x, (Object)y, (Object)z);
        super.setBlockData(x, y, z, blockData);
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, this.region.getCenter().getBlockY(), z), (String)"Coordinates %s, %s are not in the region", (int)x, (int)z);
        return super.getHighestBlockYAt(x, z);
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.getHighestBlockYAt(location);
    }

    @Override
    public int getHighestBlockYAt(int x, int z, HeightMap heightMap) {
        Preconditions.checkArgument((boolean)this.isInRegion(x, this.region.getCenter().getBlockY(), z), (String)"Coordinates %s, %s are not in the region", (int)x, (int)z);
        return super.getHighestBlockYAt(x, z, heightMap);
    }

    @Override
    public int getHighestBlockYAt(Location location, HeightMap heightMap) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.getHighestBlockYAt(location, heightMap);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType);
    }

    @Override
    public boolean generateTree(Location location, Random random, TreeType treeType, Consumer<BlockState> consumer) {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.generateTree(location, random, treeType, consumer);
    }

    @Override
    public boolean generateTree(@NotNull Location location, @NotNull Random random, @NotNull TreeType type, @Nullable Predicate<BlockState> statePredicate) {
        return false;
    }

    public Collection<class_1297> getNMSEntities() {
        this.loadEntities();
        return new ArrayList<class_1297>(this.entities);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz, Consumer<T> function, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.isInRegion(location), (String)"Coordinates %s, %s, %s are not in the region", (Object)location.getBlockX(), (Object)location.getBlockY(), (Object)location.getBlockZ());
        return super.spawn(location, clazz, function, reason);
    }

    @Override
    public void addEntityToWorld(class_1297 entity, CreatureSpawnEvent.SpawnReason reason) {
        this.entities.add(entity);
    }
}

