/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.install;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mohistmc.banner.BannerMain;
import com.mohistmc.banner.install.InstallInfo;
import com.mohistmc.banner.install.MavenDownloader;
import com.mohistmc.banner.install.MinecraftProvider;
import com.mohistmc.banner.install.Mirrors;
import com.mohistmc.banner.install.Util;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class FabricInstaller {
    private static final Set<String> BOOTSTRAP_LIBS = Set.of("net.fabricmc:intermediary:");
    private static final Set<String> BUILTIN_MODS = Set.of("net.fabricmc.fabric-api:fabric-api:");

    public static Map.Entry<String, List<Path>> applicationInstall() throws Exception {
        boolean installFabric;
        InputStream stream = BannerMain.class.getResourceAsStream("/installer.json");
        InstallInfo installInfo = (InstallInfo)new Gson().fromJson((Reader)new InputStreamReader(stream), InstallInfo.class);
        List<Supplier<Path>> suppliers = MinecraftProvider.checkMavenNoSource(installInfo.fabricDeps());
        Path path = Paths.get("libraries/net/fabricmc/fabric-loader", installInfo.installer.fabricLoader, "fabric-loader-" + installInfo.installer.fabricLoader + ".jar");
        boolean bl = installFabric = !Files.exists(path, new LinkOption[0]) || FabricInstaller.fabricClasspathMissing(path);
        if (!suppliers.isEmpty() || installFabric) {
            System.out.println("Downloading missing libraries ...");
            ExecutorService pool = Executors.newWorkStealingPool(8);
            CompletableFuture[] array = (CompletableFuture[])suppliers.stream().map(MinecraftProvider.reportSupply(pool, System.out::println)).toArray(CompletableFuture[]::new);
            if (installFabric) {
                CompletableFuture<Path>[] futures = FabricInstaller.installFabric(installInfo, pool, System.out::println);
                array = (CompletableFuture[])Stream.concat(Arrays.stream(futures), Arrays.stream(array)).toArray(CompletableFuture[]::new);
            }
            MinecraftProvider.handleFutures(System.out::println, array);
            pool.shutdownNow();
        }
        return FabricInstaller.classpath(installInfo, path);
    }

    private static Map.Entry<String, List<Path>> classpath(InstallInfo info, Path path) throws Exception {
        String mcPath = String.format("libraries/net/minecraft/server/%1$s/server-%1$s.jar", info.installer.minecraft);
        System.setProperty("fabric.gameJarPath", Paths.get(mcPath, new String[0]).toAbsolutePath().toString());
        String gameLibs = info.fabricDeps().keySet().stream().filter(it -> {
            if (!BOOTSTRAP_LIBS.stream().noneMatch(it::startsWith)) return false;
            if (!BUILTIN_MODS.stream().noneMatch(it::startsWith)) return false;
            return true;
        }).map(it -> "libraries/" + Util.mavenToPath(it)).collect(Collectors.joining(File.pathSeparator));
        System.setProperty("banner.fabric.classpath", gameLibs);
        String builtinMods = info.fabricDeps().keySet().stream().filter(it -> BUILTIN_MODS.stream().anyMatch(it::startsWith)).map(it -> "libraries/" + Util.mavenToPath(it)).collect(Collectors.joining(File.pathSeparator));
        System.setProperty("banner.fabric.builtinMods", builtinMods);
        ArrayList<Path> libs = new ArrayList<Path>();
        FabricInstaller.fabricDeps(path).keySet().stream().map(it -> Paths.get("libraries", Util.mavenToPath(it))).forEach(libs::add);
        info.fabricDeps().keySet().stream().filter(it -> BOOTSTRAP_LIBS.stream().anyMatch(it::startsWith)).forEach(it -> libs.add(Paths.get("libraries", Util.mavenToPath(it))));
        libs.add(path);
        try (JarFile file = new JarFile(path.toFile());){
            String mainClass = file.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            Map.Entry<String, List<Path>> entry = Map.entry(mainClass, libs);
            return entry;
        }
    }

    private static boolean fabricClasspathMissing(Path fabricLoader) throws Exception {
        return FabricInstaller.fabricDeps(fabricLoader).keySet().stream().anyMatch(it -> !Files.exists(Paths.get("libraries", Util.mavenToPath(it)), new LinkOption[0]));
    }

    private static Map<String, Map.Entry<String, String>> fabricDeps(Path fabricLoader) throws Exception {
        HashMap<String, Map.Entry<String, String>> ret = new HashMap<String, Map.Entry<String, String>>();
        try (JarFile file = new JarFile(fabricLoader.toFile());){
            ZipEntry entry = file.getEntry("fabric-installer.json");
            try (InputStream stream = file.getInputStream(entry);){
                JsonObject libraries = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject().getAsJsonObject("libraries");
                for (JsonArray block : List.of(libraries.getAsJsonArray("common"), libraries.getAsJsonArray("server"))) {
                    for (JsonElement element : block) {
                        JsonObject obj = element.getAsJsonObject();
                        String name = obj.get("name").getAsString();
                        String url = obj.get("url").getAsString() + Util.mavenToPath(name);
                        String hash = obj.get("sha1").getAsString();
                        ret.put(name, new AbstractMap.SimpleImmutableEntry<String, CallSite>(hash, (CallSite)((Object)url)));
                    }
                }
            }
        }
        return ret;
    }

    private static CompletableFuture<Path>[] installFabric(InstallInfo info, ExecutorService pool, Consumer<String> logger) {
        String coord = String.format("net.fabricmc:fabric-loader:%s", info.installer.fabricLoader);
        String dist = "libraries/" + Util.mavenToPath(coord);
        CompletionStage installerFuture = MinecraftProvider.reportSupply(pool, logger).apply(new MavenDownloader(Mirrors.getMavenRepo(), coord, dist, info.installer.fabricLoaderHash)).thenAccept(path -> {
            try {
                Map<String, Map.Entry<String, String>> deps = FabricInstaller.fabricDeps(path);
                List<Supplier<Path>> suppliers = MinecraftProvider.checkMaven(deps);
                CompletableFuture[] array = (CompletableFuture[])suppliers.stream().map(MinecraftProvider.reportSupply(pool, System.out::println)).toArray(CompletableFuture[]::new);
                MinecraftProvider.handleFutures(logger, array);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return new CompletableFuture[]{installerFuture};
    }
}

