/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.MohistMCStart;
import com.mohistmc.libraries.Libraries;
import com.mohistmc.tools.MD5Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import me.tongfei.progressbar.ProgressBarStyle;

public class LibrariesDownloadQueue {
    public final Set<Libraries> allLibraries = new HashSet<Libraries>();
    private final Set<Libraries> fail = new HashSet<Libraries>();
    public InputStream inputStream = null;
    public Set<Libraries> need_download = new LinkedHashSet<Libraries>();
    public Set<Libraries> installer = new LinkedHashSet<Libraries>();
    public List<URL> installerTourls = new ArrayList<URL>();
    public String parentDirectory = "libraries";
    public String systemProperty = null;
    public boolean debug = false;

    public static LibrariesDownloadQueue create() {
        return new LibrariesDownloadQueue();
    }

    public LibrariesDownloadQueue inputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public LibrariesDownloadQueue parentDirectory(String parentDirectory) {
        this.parentDirectory = parentDirectory;
        return this;
    }

    public LibrariesDownloadQueue build() {
        this.init();
        return this;
    }

    public void progressBar() {
        if (this.needDownload()) {
            ProgressBarBuilder builder = new ProgressBarBuilder().setTaskName("").setStyle(ProgressBarStyle.ASCII).setUpdateIntervalMillis(100).setInitialMax(this.need_download.size());
            try (ProgressBar pb = builder.build();){
                for (Libraries lib : this.need_download) {
                    File file = new File(this.parentDirectory, lib.path);
                    file.getParentFile().mkdirs();
                    String url = "META-INF/" + file.getPath();
                    if (this.copyFileFromJar(file, url.replaceAll("\\\\", "/"), lib)) {
                        this.debug("downloadFile: OK");
                        this.fail.remove(lib);
                    } else {
                        this.debug("downloadFile: No " + url);
                        this.fail.add(lib);
                    }
                    pb.step();
                }
            }
        }
        if (!this.fail.isEmpty()) {
            this.progressBar();
        }
    }

    protected boolean copyFileFromJar(File file, String pathInJar, Libraries lib) {
        InputStream is = MohistMCStart.class.getClassLoader().getResourceAsStream(pathInJar);
        if (!file.exists() || !MD5Util.get(file).equals(lib.getMd5()) || file.length() <= 1L) {
            file.getParentFile().mkdirs();
            if (is != null) {
                try {
                    file.createNewFile();
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    return true;
                }
                catch (IOException iOException) {}
            } else {
                System.out.println("[Mohist] The file " + file.getPath() + " doesn't exists in the Mohist jar !");
                return false;
            }
        }
        return true;
    }

    public boolean needDownload() {
        for (Libraries libraries : this.allLibraries) {
            File lib = new File(this.parentDirectory, libraries.path);
            if (lib.exists() && Objects.equals(MD5Util.get(lib), libraries.md5)) continue;
            this.need_download.add(libraries);
        }
        return !this.need_download.isEmpty();
    }

    private void init() {
        try {
            BufferedReader b = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = b.readLine();
            while (line != null) {
                Libraries libraries = Libraries.from(line);
                this.allLibraries.add(libraries);
                if (libraries.isInstaller()) {
                    File file = new File(this.parentDirectory, libraries.getPath());
                    URL url = file.toURI().toURL();
                    this.installer.add(libraries);
                    this.installerTourls.add(url);
                }
                line = b.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void debug(String log) {
        if (this.debug) {
            System.out.println(log + "\n");
        }
    }

    public String toString() {
        return "LibrariesDownloadQueue(installerTourls=" + String.valueOf(this.installerTourls) + ", parentDirectory=" + this.parentDirectory + ", systemProperty=" + this.systemProperty + ", debug=" + this.debug + ")";
    }
}

