/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.tools.ConnectionUtil;

public enum DownloadSource {
    MOHIST("https://maven.mohistmc.com/"),
    GITHUB("https://mohistmc.github.io/maven/");

    public static final DownloadSource defaultSource;
    public final String url;

    public static DownloadSource get() {
        String ds = MohistConfigUtil.LIBRARIES_DOWNLOADSOURCE();
        for (DownloadSource me : DownloadSource.values()) {
            if (!me.name().equalsIgnoreCase(ds)) continue;
            DownloadSource urL = me;
            if (!ConnectionUtil.canAccess(urL.url)) {
                return GITHUB;
            }
            return urL;
        }
        return defaultSource;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "DownloadSource." + this.name() + "(url=" + this.getUrl() + ")";
    }

    private DownloadSource(String url) {
        this.url = url;
    }

    static {
        defaultSource = MOHIST;
    }
}

