/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class BannerMain {
    public static void main(String[] args) throws Throwable {
        System.setProperty("fabric.skipMcProvider", "true");
        System.setProperty("banner.alwaysExtract", "true");
        try {
            Map.Entry<String, List<Path>> install = BannerMain.fabricInstall();
            URL ours = BannerMain.class.getProtectionDomain().getCodeSource().getLocation();
            URLClassLoader classloader = new URLClassLoader((URL[])Stream.concat(Stream.of(ours), install.getValue().stream().map(it -> {
                try {
                    return it.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            })).toArray(URL[]::new), ClassLoader.getPlatformClassLoader());
            Thread.currentThread().setContextClassLoader(classloader);
            Class<?> cl = Class.forName(install.getKey(), false, classloader);
            MethodHandle handle = MethodHandles.lookup().findStatic(cl, "main", MethodType.methodType(Void.TYPE, String[].class));
            handle.invoke(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Fail to launch Banner.");
            System.exit(-1);
        }
    }

    private static Map.Entry<String, List<Path>> fabricInstall() throws Throwable {
        Path path = Paths.get(".banner", "gson.jar");
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(Objects.requireNonNull(BannerMain.class.getResourceAsStream("/gson.jar")), path, new CopyOption[0]);
        }
        try (URLClassLoader loader = new URLClassLoader(new URL[]{path.toUri().toURL(), BannerMain.class.getProtectionDomain().getCodeSource().getLocation()}, ClassLoader.getPlatformClassLoader());){
            Class<?> cl = loader.loadClass("com.mohistmc.banner.install.FabricInstaller");
            MethodHandle handle = MethodHandles.lookup().findStatic(cl, "applicationInstall", MethodType.methodType(Map.Entry.class));
            Map.Entry entry = handle.invoke();
            return entry;
        }
    }
}

