/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.fabricmc.loader.impl.game.minecraft.MinecraftGameProvider;
import net.fabricmc.loader.impl.launch.FabricLauncher;
import net.fabricmc.loader.impl.util.Arguments;

public class BannerGameProvider
extends MinecraftGameProvider {
    private Path modFile;

    public void initialize(FabricLauncher launcher) {
        System.setProperty("log4j.configurationFile", "log4j2_banner.xml");
        try {
            this.modFile = this.extract();
            launcher.addToClassPath(this.modFile, new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String lib : System.getProperty("banner.fabric.classpath").split(File.pathSeparator)) {
            launcher.addToClassPath(Paths.get(lib, new String[0]), new String[0]);
        }
        try {
            this.extractBootstrap();
            this.extractPlugin();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.loadBootstrap(launcher);
        this.loadCustomLibs(launcher);
        super.initialize(launcher);
    }

    public Arguments getArguments() {
        Arguments arguments = super.getArguments();
        String old = arguments.get("fabric.addMods");
        String builtinMods = System.getProperty("banner.fabric.builtinMods");
        String path = this.modFile.toString() + File.pathSeparator + builtinMods;
        if (old != null) {
            path = old + File.pathSeparator + path;
        }
        arguments.put("fabric.addMods", path);
        arguments.addExtraArg("nogui");
        return arguments;
    }

    public void unlockClassPath(FabricLauncher launcher) {
        super.unlockClassPath(launcher);
        try {
            Field field = launcher.getClass().getDeclaredField("unlocked");
            field.setAccessible(true);
            field.set(launcher, true);
            Constructor ctor = launcher.loadIntoTarget("com.mohistmc.banner.boot.FabricBootstrap").getConstructor(new Class[0]);
            ((Consumer)ctor.newInstance(new Object[0])).accept(launcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getBannerVersion() throws Exception {
        try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            return string;
        }
    }

    private Path extract() throws Exception {
        Path mod;
        String version = this.getBannerVersion();
        System.setProperty("banner.version", version);
        InputStream path = ((Object)((Object)this)).getClass().getModule().getResourceAsStream("/META-INF/jars/banner-" + this.getBannerVersion() + ".jar");
        Path dir = Paths.get(".banner", "mod_file");
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(mod = dir.resolve(version + ".jar"), new LinkOption[0]) || Boolean.getBoolean("banner.alwaysExtract")) {
            try (Stream<Path> files = Files.list(dir);){
                for (Path old : files.toList()) {
                    Files.delete(old);
                }
                Files.copy(path, mod, new CopyOption[0]);
            }
        }
        return mod;
    }

    private Path extractPlugin() throws Exception {
        Path plugin;
        InputStream path = ((Object)((Object)this)).getClass().getModule().getResourceAsStream("/META-INF/jars/banner-plugin-" + this.getBannerVersion() + ".jar");
        Path dir = Paths.get(".banner", "plugin_file");
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(plugin = dir.resolve("banner-plugin-" + this.getBannerVersion() + ".jar"), new LinkOption[0]) || Boolean.getBoolean("banner.alwaysExtract")) {
            try (Stream<Path> files = Files.list(dir);){
                for (Path old : files.toList()) {
                    Files.delete(old);
                }
                Files.copy(path, plugin, new CopyOption[0]);
            }
        }
        return plugin;
    }

    private Path extractBootstrap() throws Exception {
        Path bootstrap;
        InputStream path = ((Object)((Object)this)).getClass().getModule().getResourceAsStream("/META-INF/jars/banner-bootstrap-" + this.getBannerVersion() + ".jar");
        Path dir = Paths.get(".banner", "bootstrap");
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (!Files.exists(bootstrap = dir.resolve("banner-bootstrap-" + this.getBannerVersion() + ".jar"), new LinkOption[0]) || Boolean.getBoolean("banner.alwaysExtract")) {
            try (Stream<Path> files = Files.list(dir);){
                for (Path old : files.toList()) {
                    Files.delete(old);
                }
                Files.copy(path, bootstrap, new CopyOption[0]);
            }
        }
        return bootstrap;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getRawGameVersion() {
        try {
            return super.getRawGameVersion() + " Banner " + this.getBannerVersion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadCustomLibs(FabricLauncher launcher) {
        File file = new File("libraries/customize_libraries");
        if (!file.exists()) {
            file.mkdirs();
        }
        for (File lib : file.listFiles((dir, name) -> name.endsWith(".jar"))) {
            launcher.addToClassPath(Paths.get(lib.toURI()), new String[0]);
            System.out.println(lib.getName() + " custom library loaded successfully.");
        }
    }

    private void loadBootstrap(FabricLauncher launcher) {
        try {
            File bootstrap = new File(".banner", "bootstrap/banner-bootstrap-" + this.getBannerVersion() + ".jar");
            launcher.addToClassPath(Paths.get(bootstrap.toURI()), new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

