/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.bukkit.nms.remappers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import red.mohist.bukkit.nms.proxy.DelegateClassLoder;
import red.mohist.bukkit.nms.proxy.DelegateURLClassLoder;
import red.mohist.bukkit.nms.remappers.ReflectMethodRemapper;
import red.mohist.bukkit.pluginfix.JavaScriptRemaper;

public class MohistSuperClassRemapper {
    public static Map<String, Class<?>> superClassMap = Maps.newHashMap();
    public static Map<String, Class<?>> defineClass = Maps.newHashMap();

    public static void init(ClassNode node) {
        boolean isDefineClass = false;
        Class<?> superClass = superClassMap.get(node.superName);
        if (superClass != null) {
            if (superClass == DelegateClassLoder.class) {
                defineClass.put(node.name + ";defineClass", DelegateClassLoder.class);
            }
            node.superName = superClass.getName().replace('.', '/');
            isDefineClass = true;
        }
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                MethodInsnNode insn;
                if (next instanceof TypeInsnNode && next.getOpcode() == 187) {
                    insn = (TypeInsnNode)next;
                    Class<?> remappedClass = superClassMap.get(insn.desc);
                    if (remappedClass != null) {
                        insn.desc = Type.getInternalName(remappedClass);
                        isDefineClass = true;
                    }
                }
                if (!(next instanceof MethodInsnNode)) continue;
                insn = (MethodInsnNode)next;
                switch (insn.getOpcode()) {
                    case 182: {
                        Class<?> VirtualMethodClass = ReflectMethodRemapper.getVirtualMethod().get(insn.owner + ";" + insn.name);
                        if (VirtualMethodClass != null) {
                            Type returnType = Type.getReturnType((String)insn.desc);
                            ArrayList<Type> args = new ArrayList<Type>();
                            args.add(Type.getObjectType((String)insn.owner));
                            args.addAll(Arrays.asList(Type.getArgumentTypes((String)insn.desc)));
                            insn.setOpcode(184);
                            insn.owner = Type.getInternalName(VirtualMethodClass);
                            insn.desc = Type.getMethodDescriptor((Type)returnType, (Type[])args.toArray(new Type[0]));
                            break;
                        }
                        VirtualMethodClass = defineClass.get(insn.owner + ";" + insn.name);
                        if (VirtualMethodClass == null) break;
                        insn.name = insn.name + "Mohsit";
                        insn.owner = Type.getInternalName(VirtualMethodClass);
                        break;
                    }
                    case 183: {
                        Class<?> superClassClass;
                        if (isDefineClass && (superClassClass = superClassMap.get(insn.owner)) != null && insn.name.equals("<init>")) {
                            insn.owner = Type.getInternalName(superClassClass);
                        }
                        JavaScriptRemaper.init(insn, method);
                    }
                }
            }
        }
    }

    static {
        superClassMap.put("java/net/URLClassLoader", DelegateURLClassLoder.class);
        superClassMap.put("java/lang/ClassLoader", DelegateClassLoder.class);
    }
}

