/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.configuration;

import net.minecraft.server.MinecraftServer;
import org.bukkit.configuration.file.YamlConfiguration;
import red.mohist.common.cache.TileEntityCache;
import red.mohist.configuration.BoolSetting;
import red.mohist.configuration.ConfigBase;
import red.mohist.configuration.Setting;
import red.mohist.util.TileEntity;

public class TileEntityConfig
extends ConfigBase {
    private final String HEADER = "This is the main configuration file for TileEntities.\nUse carefully, it may break some mechanics";
    public static TileEntityConfig instance;
    public final BoolSetting skipTileEntityTicks = new BoolSetting(this, "settings.skip-tileentity-ticks", true, "If enabled, turns on tileentity tick skip feature.");

    public TileEntityConfig() {
        super("tileentity.yml");
        this.init();
        instance = this;
    }

    public void init() {
        this.settings.put(this.skipTileEntityTicks.path, this.skipTileEntityTicks);
        this.load();
    }

    @Override
    public void load() {
        try {
            this.config = YamlConfiguration.loadConfiguration(this.configFile);
            String header = "This is the main configuration file for TileEntities.\nUse carefully, it may break some mechanics\n";
            for (Setting toggle : this.settings.values()) {
                if (!toggle.description.equals("")) {
                    header = header + "Setting: " + toggle.path + " Default: " + toggle.def + "   # " + toggle.description + "\n";
                }
                this.config.addDefault(toggle.path, toggle.def);
                ((Setting)this.settings.get(toggle.path)).setValue(this.config.getString(toggle.path));
            }
            this.config.options().header(header);
            this.config.options().copyDefaults(true);
            this.version = this.getInt("config-version", 1);
            this.set("config-version", 1);
            for (TileEntityCache teCache : TileEntity.tileEntityCache.values()) {
                teCache.tickNoPlayers = this.config.getBoolean("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-no-players", this.config.getBoolean("world-settings.default." + teCache.configPath + ".tick-no-players"));
                teCache.tickInterval = this.config.getInt("world-settings." + teCache.worldName + "." + teCache.configPath + ".tick-interval", this.config.getInt("world-settings.default." + teCache.configPath + ".tick-interval"));
            }
            this.save();
        }
        catch (Exception ex2) {
            MinecraftServer.k.warn("Could not load " + this.configFile);
            ex2.printStackTrace();
        }
    }
}

