/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.network.download;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;
import red.mohist.Mohist;
import red.mohist.configuration.MohistConfigUtil;
import red.mohist.network.download.NetworkUtil;
import red.mohist.util.i18n.Message;

public class UpdateUtils {
    static String ci_sha;
    static String jar_sha;
    static String time;
    private static int percentage;
    private static int fS;

    public static void versionCheck() {
        System.out.println(Message.getString("update.check"));
        System.out.println(Message.getString("update.stopcheck"));
        try {
            JsonElement root = new JsonParser().parse((Reader)new InputStreamReader((InputStream)NetworkUtil.getConn("https://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/api/json").getContent()));
            jar_sha = UpdateUtils.class.getPackage().getImplementationVersion();
            String[] ci_sha_date = root.getAsJsonObject().get("artifacts").getAsJsonArray().get(0).getAsJsonObject().get("displayPath").toString().split("-");
            ci_sha = "1.12.2-" + ci_sha_date[2];
            String timestamp = root.getAsJsonObject().get("timestamp").toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = sdf.format(new Date(Long.parseLong(timestamp)));
            if (jar_sha.equals(ci_sha)) {
                System.out.println(Message.getFormatString("update.latest", new Object[]{"1.9", jar_sha, ci_sha}));
            } else {
                System.out.println(Message.getFormatString("update.detect", new Object[]{ci_sha, jar_sha, time}));
                if (MohistConfigUtil.bMohist("check_update_auto_download")) {
                    UpdateUtils.downloadFile("https://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/artifact/build/distributions/Mohist-" + ci_sha + "-server.jar", new File(new File(Mohist.class.getProtectionDomain().getCodeSource().getLocation().getPath().substring(1)).getName()));
                }
            }
        }
        catch (Throwable e2) {
            System.out.println(Message.getString("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, final File f2) throws Exception {
        fS = NetworkUtil.getConnLength(URL2);
        System.out.println(Message.getFormatString("file.download.start", new Object[]{f2.getName(), UpdateUtils.getSize(fS)}));
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (percentage != Math.round((float)f2.length() / (float)fS * 100.0f)) {
                    System.out.println(Message.getFormatString("file.download.percentage", new Object[]{f2.getName(), percentage}));
                }
                percentage = Math.round((float)f2.length() / (float)fS * 100.0f);
            }
        }, 3000L, 1000L);
        FileChannel.open(Paths.get(f2.getAbsolutePath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING).transferFrom(Channels.newChannel(NetworkUtil.getInput(URL2)), 0L, Long.MAX_VALUE);
        t.cancel();
        if (URL2.contains("codemc.io")) {
            UpdateUtils.restartServer(new ArrayList<String>(Arrays.asList("java", "-jar", new File(Mohist.class.getProtectionDomain().getCodeSource().getLocation().getPath().substring(1)).getName())));
        } else {
            System.out.println(Message.getFormatString("file.download.ok", new Object[]{f2.getName()}));
        }
    }

    public static void restartServer(ArrayList<String> cmd) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.waitFor();
        Thread.sleep(2000L);
        System.exit(0);
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static long getSizeOfDirectory(File path) throws IOException {
        return ((Stream)Files.walk(path.toPath(), new FileVisitOption[0]).parallel()).filter(p2 -> !p2.toFile().isDirectory()).count();
    }

    static {
        percentage = 0;
        fS = 0;
    }
}

