/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.configuration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import red.mohist.api.ServerAPI;
import red.mohist.configuration.Setting;

public abstract class ConfigBase {
    protected final File configFile;
    private static boolean metricsStarted;
    public YamlConfiguration config;
    protected int version;
    protected Map<String, Setting> settings = new HashMap<String, Setting>();

    public ConfigBase(String fileName) {
        this.configFile = new File("mohist-config", fileName);
        this.config = YamlConfiguration.loadConfiguration(this.configFile);
    }

    public Map<String, Setting> getSettings() {
        return this.settings;
    }

    public void save() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException ex2) {
            ServerAPI.getNMSServer().g("Could not save " + this.configFile);
            ex2.printStackTrace();
        }
    }

    protected abstract void load();

    public void set(String path, Object val) {
        this.config.set(path, val);
    }

    public boolean isSet(String path) {
        return this.config.isSet(path);
    }

    public boolean isInt(String path) {
        return this.config.isInt(path);
    }

    public boolean isBoolean(String path) {
        return this.config.isBoolean(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getBoolean(path, def, true);
    }

    public boolean getBoolean(String path, boolean def, boolean useDefault) {
        if (useDefault) {
            this.config.addDefault(path, def);
        }
        return this.config.getBoolean(path, def);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public int getInt(String path, int def) {
        this.config.addDefault(path, def);
        return this.config.getInt(path, this.config.getInt(path));
    }

    public <T> List getList(String path, T def) {
        this.config.addDefault(path, def);
        return this.config.getList(path, this.config.getList(path));
    }

    public String getString(String path, String def) {
        return this.getString(path, def, true);
    }

    public String getString(String path, String def, boolean useDefault) {
        if (useDefault) {
            this.config.addDefault(path, def);
        }
        return this.config.getString(path, def);
    }

    public List<String> getStringList(String path, List<String> def) {
        this.config.addDefault(path, def);
        return this.config.getStringList(path);
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }

    public String getFakePlayer(String className, String defaultName) {
        return this.getString("fake-players." + className + ".username", defaultName);
    }

    private static String transform(String s) {
        return ChatColor.translateAlternateColorCodes('&', s).replaceAll("\\\\n", "\n");
    }
}

