/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FindClassInJar {
    private String m_libDir;
    private String m_classname;

    public FindClassInJar(String libDir, String classname) {
        this.m_libDir = libDir;
        this.m_classname = classname;
    }

    public void process() throws IOException {
        this.checkDirectory(this.m_libDir);
    }

    public void checkDirectory(String libDir) throws IOException {
        File file = new File(libDir);
        if (file.exists()) {
            if (file.isFile()) {
                if (this.checkFile(file)) {
                    // empty if block
                }
            } else {
                File[] files = file.listFiles(new JarZipFileFilter());
                for (int i2 = 0; i2 < files.length; ++i2) {
                    File f2 = files[i2];
                    if (f2.isDirectory()) {
                        this.checkDirectory(f2.getAbsolutePath());
                        continue;
                    }
                    if (!this.checkFile(f2)) continue;
                    File newf = new File("delete/mods");
                    File qnewf = new File("delete", f2.getPath());
                    if (!newf.exists()) {
                        newf.mkdirs();
                    } else if (qnewf.exists()) {
                        qnewf.delete();
                    }
                    Files.copy(f2.toPath(), qnewf.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    f2.delete();
                }
            }
        }
    }

    private boolean checkFile(File f2) {
        boolean result = false;
        try {
            JarFile jarFile = new JarFile(f2);
            Enumeration<JarEntry> enu = jarFile.entries();
            while (enu.hasMoreElements()) {
                JarEntry entry = enu.nextElement();
                String name = entry.getName();
                if (entry.isDirectory() || !name.equals(this.m_classname)) continue;
                result = true;
                break;
            }
            jarFile.close();
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
        return result;
    }

    class JarZipFileFilter
    implements FileFilter {
        JarZipFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase();
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

