/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeVersion {
    public static final String MOD_ID = "forge";
    public static final int majorVersion = com.mohistmc.forge.ForgeVersion.major;
    public static final int minorVersion = com.mohistmc.forge.ForgeVersion.minor;
    public static final int revisionVersion = com.mohistmc.forge.ForgeVersion.revision;
    public static final int buildVersion = com.mohistmc.forge.ForgeVersion.build;
    public static final String mcVersion = "1.12.2";
    public static final String mcpVersion = "9.42";
    private static Status status = Status.PENDING;
    private static String target = null;
    private static final Logger log = LogManager.getLogger((String)"forge.VersionCheck");
    private static final int MAX_HTTP_REDIRECTS = Integer.getInteger("http.maxRedirects", 20);
    private static Map<ModContainer, CheckResult> results = new ConcurrentHashMap<ModContainer, CheckResult>();
    private static final CheckResult PENDING_CHECK = new CheckResult(Status.PENDING, null, null, null);

    public static int getMajorVersion() {
        return majorVersion;
    }

    public static int getMinorVersion() {
        return minorVersion;
    }

    public static int getRevisionVersion() {
        return revisionVersion;
    }

    public static int getBuildVersion() {
        return buildVersion;
    }

    public static Status getStatus() {
        return ForgeVersion.getResult((ModContainer)ForgeModContainer.getInstance()).status;
    }

    @Nullable
    public static String getTarget() {
        CheckResult res = ForgeVersion.getResult(ForgeModContainer.getInstance());
        return res.target != null ? res.target.toString() : null;
    }

    public static String getVersion() {
        return String.format("%d.%d.%d.%d", majorVersion, minorVersion, revisionVersion, buildVersion);
    }

    public static void startVersionCheck() {
        new Thread("Forge Version Check"){

            @Override
            public void run() {
                if (!ForgeModContainer.getConfig().get("version_checking", "Global", true).getBoolean()) {
                    log.info("Global Forge version check system disabled, no further processing.");
                    return;
                }
                for (Map.Entry<ModContainer, URL> entry : ForgeVersion.gatherMods().entrySet()) {
                    ModContainer mod = entry.getKey();
                    if (ForgeModContainer.getConfig().get("version_checking", mod.getModId(), true).getBoolean()) {
                        this.process(mod, entry.getValue());
                        continue;
                    }
                    log.info("[{}] Skipped version check", (Object)mod.getModId());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private InputStream openUrlStream(URL url) throws IOException {
                URL currentUrl = url;
                for (int redirects = 0; redirects < MAX_HTTP_REDIRECTS; ++redirects) {
                    URLConnection c2 = currentUrl.openConnection();
                    if (c2 instanceof HttpURLConnection) {
                        HttpURLConnection huc = (HttpURLConnection)c2;
                        huc.setInstanceFollowRedirects(false);
                        int responseCode = huc.getResponseCode();
                        if (responseCode >= 300 && responseCode <= 399) {
                            try {
                                String loc = huc.getHeaderField("Location");
                                currentUrl = new URL(currentUrl, loc);
                                continue;
                            }
                            finally {
                                huc.disconnect();
                            }
                        }
                    }
                    return c2.getInputStream();
                }
                throw new IOException("Too many redirects while trying to fetch " + url);
            }

            private void process(ModContainer mod, URL url) {
                try {
                    log.info("[{}] Starting version check at {}", (Object)mod.getModId(), (Object)url.toString());
                    Status status = Status.PENDING;
                    ComparableVersion target = null;
                    InputStream con = this.openUrlStream(url);
                    String data = new String(ByteStreams.toByteArray((InputStream)con), "UTF-8");
                    con.close();
                    log.debug("[{}] Received version check data:\n{}", (Object)mod.getModId(), (Object)data);
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    Map promos = (Map)json.get("promos");
                    String display_url = (String)json.get("homepage");
                    String rec = (String)promos.get("1.12.2-recommended");
                    String lat = (String)promos.get("1.12.2-latest");
                    ComparableVersion current = new ComparableVersion(mod.getVersion());
                    if (rec != null) {
                        ComparableVersion recommended = new ComparableVersion(rec);
                        int diff = recommended.compareTo(current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            ComparableVersion latest;
                            status = Status.AHEAD;
                            if (lat != null && current.compareTo(latest = new ComparableVersion(lat)) < 0) {
                                status = Status.OUTDATED;
                                target = latest;
                            }
                        } else {
                            status = Status.OUTDATED;
                            target = recommended;
                        }
                    } else if (lat != null) {
                        ComparableVersion latest = new ComparableVersion(lat);
                        if (current.compareTo(latest) < 0) {
                            status = Status.BETA_OUTDATED;
                            target = latest;
                        } else {
                            status = Status.BETA;
                        }
                    } else {
                        status = Status.BETA;
                    }
                    log.info("[{}] Found status: {} Target: {}", (Object)mod.getModId(), (Object)status, target);
                    LinkedHashMap changes = new LinkedHashMap();
                    Map tmp = (Map)json.get(ForgeVersion.mcVersion);
                    if (tmp != null) {
                        ArrayList<ComparableVersion> ordered = new ArrayList<ComparableVersion>();
                        for (String key : tmp.keySet()) {
                            ComparableVersion ver = new ComparableVersion(key);
                            if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                            ordered.add(ver);
                        }
                        Collections.sort(ordered);
                        for (ComparableVersion ver : ordered) {
                            changes.put(ver, tmp.get(ver.toString()));
                        }
                    }
                    if (mod instanceof InjectedModContainer) {
                        mod = ((InjectedModContainer)mod).wrappedContainer;
                    }
                    results.put(mod, new CheckResult(status, target, changes, display_url));
                }
                catch (Exception e) {
                    log.debug("Failed to process update information", (Throwable)e);
                    status = Status.FAILED;
                }
            }
        }.start();
    }

    public static Map<ModContainer, URL> gatherMods() {
        HashMap<ModContainer, URL> ret = new HashMap<ModContainer, URL>();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            URL url = mod.getUpdateUrl();
            if (url == null) continue;
            ret.put(mod, url);
        }
        return ret;
    }

    public static CheckResult getResult(ModContainer mod) {
        CheckResult ret;
        if (mod == null) {
            return PENDING_CHECK;
        }
        if (mod instanceof InjectedModContainer) {
            mod = ((InjectedModContainer)mod).wrappedContainer;
        }
        return (ret = results.get(mod)) == null ? PENDING_CHECK : ret;
    }

    public static class CheckResult {
        public final Status status;
        @Nullable
        public final ComparableVersion target;
        public final Map<ComparableVersion, String> changes;
        @Nullable
        public final String url;

        private CheckResult(Status status, @Nullable ComparableVersion target, @Nullable Map<ComparableVersion, String> changes, @Nullable String url) {
            this.status = status;
            this.target = target;
            this.changes = changes == null ? Collections.emptyMap() : Collections.unmodifiableMap(changes);
            this.url = url;
        }
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED(3, true),
        AHEAD,
        BETA,
        BETA_OUTDATED(6, true);

        final int sheetOffset;
        final boolean draw;
        final boolean animated;

        private Status() {
            this(0, false, false);
        }

        private Status(int sheetOffset) {
            this(sheetOffset, true, false);
        }

        private Status(int sheetOffset, boolean animated) {
            this(sheetOffset, true, animated);
        }

        private Status(int sheetOffset, boolean draw, boolean animated) {
            this.sheetOffset = sheetOffset;
            this.draw = draw;
            this.animated = animated;
        }

        public int getSheetOffset() {
            return this.sheetOffset;
        }

        public boolean shouldDraw() {
            return this.draw;
        }

        public boolean isAnimated() {
            return this.animated;
        }
    }
}

