/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import red.mohist.util.i18n.Message;

public class ForgeChunkManager {
    private static int defaultMaxCount;
    private static int defaultMaxChunks;
    private static boolean overridesEnabled;
    private static Map<amu, Multimap<String, Ticket>> tickets;
    private static Map<String, Integer> ticketConstraints;
    private static Map<String, Integer> chunkConstraints;
    private static SetMultimap<String, Ticket> playerTickets;
    private static Map<String, LoadingCallback> callbacks;
    private static Map<amu, ImmutableSetMultimap<amn, Ticket>> forcedChunks;
    private static BiMap<UUID, Ticket> pendingEntities;
    private static Map<amu, Cache<Long, ChunkEntry>> dormantChunkCache;
    private static File cfgFile;
    private static Configuration config;
    private static int playerTicketLength;
    private static int dormantChunkCacheSize;
    public static boolean asyncChunkLoading;
    public static final List<String> MOD_PROP_ORDER;
    private static Set<String> warnedMods;

    public static Iterator<axw> getPersistentChunksIterableFor(amu world, Iterator<axw> chunkIterator) {
        ImmutableSetMultimap<amn, Ticket> persistentChunksFor = ForgeChunkManager.getPersistentChunksFor(world);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        world.E.a("forcedChunkLoading");
        builder.addAll(persistentChunksFor.keys().stream().filter(Objects::nonNull).map(input -> world.a(input.a, input.b)).iterator());
        world.E.c("regularChunkLoading");
        builder.addAll(chunkIterator);
        world.E.b();
        return builder.build().iterator();
    }

    public static boolean savedWorldHasForcedChunkTickets(File chunkDir) {
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        if (chunkLoaderData.exists() && chunkLoaderData.isFile()) {
            try {
                fy forcedChunkData = gi.a((File)chunkLoaderData);
                return forcedChunkData.c("TicketList", 10).c() > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    static void loadWorld(amu world) {
        oo worldServer;
        File chunkDir;
        File chunkLoaderData;
        ArrayListMultimap newTickets = ArrayListMultimap.create();
        tickets.put(world, (Multimap<String, Ticket>)newTickets);
        forcedChunks.put(world, (ImmutableSetMultimap<amn, Ticket>)ImmutableSetMultimap.of());
        if (!(world instanceof oo)) {
            return;
        }
        if (dormantChunkCacheSize != 0) {
            dormantChunkCache.put(world, (Cache<Long, ChunkEntry>)CacheBuilder.newBuilder().maximumSize((long)dormantChunkCacheSize).build());
        }
        if ((chunkLoaderData = new File(chunkDir = (worldServer = (oo)world).getChunkSaveLocation(), "forcedchunks.dat")).exists() && chunkLoaderData.isFile()) {
            LoadingCallback loadingCallback;
            Object tickets;
            fy forcedChunkData;
            ArrayListMultimap loadedTickets = ArrayListMultimap.create();
            HashMap playerLoadedTickets = Maps.newHashMap();
            try {
                forcedChunkData = gi.a((File)chunkLoaderData);
            }
            catch (IOException e) {
                FMLLog.log.warn("Unable to read forced chunk data at {} - it will be ignored", (Object)chunkLoaderData.getAbsolutePath(), (Object)e);
                return;
            }
            ge ticketList = forcedChunkData.c("TicketList", 10);
            for (int i2 = 0; i2 < ticketList.c(); ++i2) {
                fy ticketHolder = ticketList.b(i2);
                String modId = ticketHolder.l("Owner");
                boolean isPlayer = "forge".equals(modId);
                if (!isPlayer && !Loader.isModLoaded(modId)) {
                    FMLLog.log.warn("Found chunkloading data for mod {} which is currently not available or active - it will be removed from the world save", (Object)modId);
                    continue;
                }
                if (!isPlayer && !callbacks.containsKey(modId)) {
                    FMLLog.log.warn("The mod {} has registered persistent chunkloading data but doesn't seem to want to be called back with it - it will be removed from the world save", (Object)modId);
                    continue;
                }
                tickets = ticketHolder.c("Tickets", 10);
                for (int j = 0; j < tickets.c(); ++j) {
                    fy ticket = tickets.b(j);
                    modId = ticket.e("ModId") ? ticket.l("ModId") : modId;
                    Type type = Type.values()[ticket.f("Type")];
                    Ticket tick = new Ticket(modId, type, world);
                    if (ticket.e("ModData")) {
                        tick.modData = ticket.p("ModData");
                    }
                    if (ticket.e("Player")) {
                        tick.player = ticket.l("Player");
                        if (!playerLoadedTickets.containsKey(tick.modId)) {
                            playerLoadedTickets.put(modId, ArrayListMultimap.create());
                        }
                        ((ListMultimap)playerLoadedTickets.get(tick.modId)).put((Object)tick.player, (Object)tick);
                    } else {
                        loadedTickets.put((Object)modId, (Object)tick);
                    }
                    if (type != Type.ENTITY) continue;
                    tick.entityChunkX = ticket.h("chunkX");
                    tick.entityChunkZ = ticket.h("chunkZ");
                    UUID uuid = new UUID(ticket.i("PersistentIDMSB"), ticket.i("PersistentIDLSB"));
                    pendingEntities.put((Object)uuid, (Object)tick);
                }
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                world.a(tick.entityChunkX, tick.entityChunkZ);
            }
            for (Ticket tick : ImmutableSet.copyOf((Collection)pendingEntities.values())) {
                if (tick.ticketType != Type.ENTITY || tick.entity != null) continue;
                FMLLog.log.warn("Failed to load persistent chunkloading entity {} from store.", pendingEntities.inverse().get((Object)tick));
                loadedTickets.remove((Object)tick.modId, (Object)tick);
            }
            pendingEntities.clear();
            for (String modId : loadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                if (loadingCallback == null) continue;
                int maxTicketLength = ForgeChunkManager.getMaxTicketLengthFor(modId);
                tickets = loadedTickets.get((Object)modId);
                if (loadingCallback instanceof OrderedLoadingCallback) {
                    OrderedLoadingCallback orderedLoadingCallback = (OrderedLoadingCallback)loadingCallback;
                    tickets = orderedLoadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets), world, maxTicketLength);
                }
                if (tickets.size() > maxTicketLength) {
                    FMLLog.log.warn("The mod {} has too many open chunkloading tickets: {} (max: {}). Excess will be dropped.", (Object)modId, (Object)tickets.size(), (Object)maxTicketLength);
                    tickets = tickets.subList(0, maxTicketLength);
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)modId, (Iterable)tickets);
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets), world);
            }
            for (String modId : playerLoadedTickets.keySet()) {
                loadingCallback = callbacks.get(modId);
                if (loadingCallback == null) continue;
                ListMultimap<String, Ticket> tickets2 = (ListMultimap<String, Ticket>)playerLoadedTickets.get(modId);
                if (loadingCallback instanceof PlayerOrderedLoadingCallback) {
                    PlayerOrderedLoadingCallback orderedLoadingCallback = (PlayerOrderedLoadingCallback)loadingCallback;
                    tickets2 = orderedLoadingCallback.playerTicketsLoaded((ListMultimap<String, Ticket>)ImmutableListMultimap.copyOf((Multimap)tickets2), world);
                    playerTickets.putAll(tickets2);
                }
                ForgeChunkManager.tickets.get(world).putAll((Object)"forge", (Iterable)tickets2.values());
                loadingCallback.ticketsLoaded((List<Ticket>)ImmutableList.copyOf((Collection)tickets2.values()), world);
            }
        }
    }

    static void unloadWorld(amu world) {
        forcedChunks.remove(world);
        if (!(world instanceof oo)) {
            return;
        }
        if (dormantChunkCacheSize != 0) {
            dormantChunkCache.remove(world);
        }
        if (!FMLCommonHandler.instance().getMinecraftServerInstance().w()) {
            playerTickets.clear();
            tickets.clear();
        }
    }

    public static void setForcedChunkLoadingCallback(Object mod, LoadingCallback callback) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.log.warn("Unable to register a callback for an unknown mod {} ({} : {})", mod, (Object)mod.getClass().getName(), (Object)Integer.toHexString(System.identityHashCode(mod)));
            return;
        }
        callbacks.put(container.getModId(), callback);
    }

    public static int ticketCountAvailableFor(Object mod, amu world) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            String modId = container.getModId();
            int allowedCount = ForgeChunkManager.getMaxTicketLengthFor(modId);
            return allowedCount - tickets.get(world).get((Object)modId).size();
        }
        return 0;
    }

    private static ModContainer getContainer(Object mod) {
        ModContainer container = (ModContainer)Loader.instance().getModObjectList().inverse().get(mod);
        return container;
    }

    public static int getMaxTicketLengthFor(String modId) {
        int allowedCount = ticketConstraints.containsKey(modId) && overridesEnabled ? ticketConstraints.get(modId) : defaultMaxCount;
        return allowedCount;
    }

    public static int getMaxChunkDepthFor(String modId) {
        int allowedCount = chunkConstraints.containsKey(modId) && overridesEnabled ? chunkConstraints.get(modId) : defaultMaxChunks;
        return allowedCount;
    }

    public static int ticketCountAvailableFor(String username) {
        return playerTicketLength - playerTickets.get((Object)username).size();
    }

    @Nullable
    public static Ticket requestPlayerTicket(Object mod, String player, amu world, Type type) {
        ModContainer mc = ForgeChunkManager.getContainer(mod);
        if (mc == null) {
            FMLLog.log.error("Failed to locate the container for mod instance {} ({} : {})", mod, (Object)mod.getClass().getName(), (Object)Integer.toHexString(System.identityHashCode(mod)));
            return null;
        }
        if (playerTickets.get((Object)player).size() > playerTicketLength) {
            FMLLog.log.warn("Unable to assign further chunkloading tickets to player {} (on behalf of mod {})", (Object)player, (Object)mc.getModId());
            return null;
        }
        Ticket ticket = new Ticket(mc.getModId(), type, world, player);
        playerTickets.put((Object)player, (Object)ticket);
        tickets.get(world).put((Object)"forge", (Object)ticket);
        return ticket;
    }

    @Nullable
    public static Ticket requestTicket(Object mod, amu world, Type type) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container == null) {
            FMLLog.log.error("Failed to locate the container for mod instance {} ({} : {})", mod, (Object)mod.getClass().getName(), (Object)Integer.toHexString(System.identityHashCode(mod)));
            return null;
        }
        String modId = container.getModId();
        if (!callbacks.containsKey(modId)) {
            FMLLog.log.fatal("The mod {} has attempted to request a ticket without a listener in place", (Object)modId);
            throw new RuntimeException("Invalid ticket request");
        }
        int allowedCount = ForgeChunkManager.getMaxTicketLengthFor(modId);
        if (tickets.get(world).get((Object)modId).size() >= allowedCount) {
            if (!warnedMods.contains(modId)) {
                FMLLog.log.info("The mod {} has attempted to allocate a chunkloading ticket beyond it's currently allocated maximum: {}", (Object)modId, (Object)allowedCount);
                warnedMods.add(modId);
            }
            return null;
        }
        Ticket ticket = new Ticket(modId, type, world);
        tickets.get(world).put((Object)modId, (Object)ticket);
        return ticket;
    }

    public static void releaseTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            return;
        }
        if (ticket.requestedChunks != null) {
            for (amn chunk : ImmutableSet.copyOf((Collection)ticket.requestedChunks)) {
                ForgeChunkManager.unforceChunk(ticket, chunk);
            }
        }
        if (ticket.isPlayerTicket()) {
            playerTickets.remove((Object)ticket.player, (Object)ticket);
            tickets.get(ticket.world).remove((Object)"forge", (Object)ticket);
        } else {
            tickets.get(ticket.world).remove((Object)ticket.modId, (Object)ticket);
        }
    }

    public static void forceChunk(Ticket ticket, amn chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        if (ticket.ticketType == Type.ENTITY && ticket.entity == null) {
            throw new RuntimeException("Attempted to use an entity ticket to force a chunk, without an entity");
        }
        if (ticket.isPlayerTicket() ? !playerTickets.containsValue((Object)ticket) : !tickets.get(ticket.world).containsEntry((Object)ticket.modId, (Object)ticket)) {
            FMLLog.log.fatal("The mod {} attempted to force load a chunk with an invalid ticket. This is not permitted.", (Object)ticket.modId);
            return;
        }
        ticket.requestedChunks.add(chunk);
        MinecraftForge.EVENT_BUS.post(new ForceChunkEvent(ticket, chunk));
        ImmutableSetMultimap newMap = ImmutableSetMultimap.builder().putAll((Multimap)forcedChunks.get(ticket.world)).put((Object)chunk, (Object)ticket).build();
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<amn, Ticket>)newMap);
        if (ticket.maxDepth > 0 && ticket.requestedChunks.size() > ticket.maxDepth) {
            amn removed = (amn)ticket.requestedChunks.iterator().next();
            ForgeChunkManager.unforceChunk(ticket, removed);
        }
    }

    public static void reorderChunk(Ticket ticket, amn chunk) {
        if (ticket == null || chunk == null || !ticket.requestedChunks.contains(chunk)) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        ticket.requestedChunks.add(chunk);
    }

    public static void unforceChunk(Ticket ticket, amn chunk) {
        if (ticket == null || chunk == null) {
            return;
        }
        ticket.requestedChunks.remove(chunk);
        MinecraftForge.EVENT_BUS.post(new UnforceChunkEvent(ticket, chunk));
        LinkedHashMultimap copy = LinkedHashMultimap.create((Multimap)((Multimap)forcedChunks.get(ticket.world)));
        copy.remove((Object)chunk, (Object)ticket);
        ImmutableSetMultimap newMap = ImmutableSetMultimap.copyOf((Multimap)copy);
        forcedChunks.put(ticket.world, (ImmutableSetMultimap<amn, Ticket>)newMap);
    }

    static void loadConfiguration() {
        ticketConstraints.clear();
        chunkConstraints.clear();
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("forge") || mod.equals("defaults")) continue;
            Property modTC = config.get(mod, "maximumTicketCount", 200);
            Property modCPT = config.get(mod, "maximumChunksPerTicket", 25);
            ticketConstraints.put(mod, modTC.getInt(200));
            chunkConstraints.put(mod, modCPT.getInt(25));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static ImmutableSetMultimap<amn, Ticket> getPersistentChunksFor(amu world) {
        if (world.G) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap persistentChunks = forcedChunks.get(world);
        return persistentChunks != null ? persistentChunks : ImmutableSetMultimap.of();
    }

    static void saveWorld(amu world) {
        if (!(world instanceof oo)) {
            return;
        }
        oo worldServer = (oo)world;
        File chunkDir = worldServer.getChunkSaveLocation();
        File chunkLoaderData = new File(chunkDir, "forcedchunks.dat");
        fy forcedChunkData = new fy();
        ge ticketList = new ge();
        forcedChunkData.a("TicketList", (gn)ticketList);
        Multimap<String, Ticket> ticketSet = tickets.get(worldServer);
        if (ticketSet == null) {
            return;
        }
        for (String modId : ticketSet.keySet()) {
            fy ticketHolder = new fy();
            ticketList.a((gn)ticketHolder);
            ticketHolder.a("Owner", modId);
            ge tickets = new ge();
            ticketHolder.a("Tickets", (gn)tickets);
            for (Ticket tick : ticketSet.get((Object)modId)) {
                fy ticket = new fy();
                ticket.a("Type", (byte)tick.ticketType.ordinal());
                ticket.a("ChunkListDepth", (byte)tick.maxDepth);
                if (tick.isPlayerTicket()) {
                    ticket.a("ModId", tick.modId);
                    ticket.a("Player", tick.player);
                }
                if (tick.modData != null) {
                    ticket.a("ModData", (gn)tick.modData);
                }
                if (tick.ticketType == Type.ENTITY && tick.entity != null && tick.entity.d(new fy())) {
                    ticket.a("chunkX", rk.d((float)((Ticket)tick).entity.ab));
                    ticket.a("chunkZ", rk.d((float)((Ticket)tick).entity.ad));
                    ticket.a("PersistentIDMSB", tick.entity.getPersistentID().getMostSignificantBits());
                    ticket.a("PersistentIDLSB", tick.entity.getPersistentID().getLeastSignificantBits());
                    tickets.a((gn)ticket);
                    continue;
                }
                if (tick.ticketType == Type.ENTITY) continue;
                tickets.a((gn)ticket);
            }
        }
        bgx.a().a(() -> {
            try {
                gi.b((fy)forcedChunkData, (File)chunkLoaderData);
            }
            catch (IOException e) {
                FMLLog.log.warn("Unable to write forced chunk data to {} - chunkloading won't work", (Object)chunkLoaderData.getAbsolutePath(), (Object)e);
            }
            return false;
        });
    }

    static void loadEntity(vg entity) {
        UUID id = entity.getPersistentID();
        Ticket tick = (Ticket)pendingEntities.get((Object)id);
        if (tick != null) {
            tick.bindEntity(entity);
            pendingEntities.remove((Object)id);
        }
    }

    public static void putDormantChunk(long coords, axw chunk) {
        if (dormantChunkCacheSize == 0) {
            return;
        }
        Cache<Long, ChunkEntry> cache = dormantChunkCache.get(chunk.q());
        if (cache != null) {
            cache.put((Object)coords, (Object)new ChunkEntry(chunk));
        }
    }

    public static void storeChunkNBT(axw chunk, fy nbt) {
        if (dormantChunkCacheSize == 0) {
            return;
        }
        Cache<Long, ChunkEntry> cache = dormantChunkCache.get(chunk.q());
        if (cache == null) {
            return;
        }
        ChunkEntry entry = (ChunkEntry)cache.getIfPresent((Object)amn.a((int)chunk.b, (int)chunk.c));
        if (entry != null) {
            entry.nbt.a("Entities", (gn)nbt.c("Entities", 10));
            entry.nbt.a("TileEntities", (gn)nbt.c("TileEntities", 10));
            qx[] entityLists = chunk.t();
            for (int i2 = 0; i2 < entityLists.length; ++i2) {
                entityLists[i2] = new qx(vg.class);
            }
            chunk.s().clear();
        }
    }

    @Nullable
    public static axw fetchDormantChunk(long coords, amu world) {
        if (dormantChunkCacheSize == 0) {
            return null;
        }
        Cache<Long, ChunkEntry> cache = dormantChunkCache.get(world);
        if (cache == null) {
            return null;
        }
        ChunkEntry entry = (ChunkEntry)cache.getIfPresent((Object)coords);
        if (entry == null) {
            return null;
        }
        ForgeChunkManager.loadChunkEntities(entry.chunk, entry.nbt, world);
        cache.invalidate((Object)coords);
        return entry.chunk;
    }

    private static void loadChunkEntities(axw chunk, fy nbt, amu world) {
        ge entities = nbt.c("Entities", 10);
        for (int i2 = 0; i2 < entities.c(); ++i2) {
            aye.a((fy)entities.b(i2), (amu)world, (axw)chunk);
            chunk.g(true);
        }
        ge tileEntities = nbt.c("TileEntities", 10);
        for (int i3 = 0; i3 < tileEntities.c(); ++i3) {
            avj tileEntity = avj.a((amu)world, (fy)tileEntities.b(i3));
            if (tileEntity == null) continue;
            chunk.a(tileEntity);
        }
    }

    static void captureConfig(File configDir) {
        cfgFile = new File(configDir, "forgeChunkLoading.cfg");
        config = new Configuration(cfgFile, true);
        try {
            config.load();
        }
        catch (Exception e) {
            File dest = new File(cfgFile.getParentFile(), "forgeChunkLoading.cfg.bak");
            if (dest.exists()) {
                dest.delete();
            }
            cfgFile.renameTo(dest);
            FMLLog.log.error("A critical error occurred reading the forgeChunkLoading.cfg file, defaults will be used - the invalid file is backed up at forgeChunkLoading.cfg.bak", (Throwable)e);
        }
        ForgeChunkManager.syncConfigDefaults();
    }

    public static void syncConfigDefaults() {
        ArrayList<String> propOrder = new ArrayList<String>();
        config.setCategoryComment("defaults", "Default configuration for forge chunk loading control").setCategoryRequiresWorldRestart("defaults", true);
        Property temp = config.get("defaults", "enabled", true);
        temp.setComment("Are mod overrides enabled?");
        temp.setLanguageKey("forge.configgui.enableModOverrides");
        overridesEnabled = temp.getBoolean(true);
        propOrder.add("enabled");
        temp = config.get("defaults", "maximumChunksPerTicket", 25);
        temp.setComment("The default maximum number of chunks a mod can force, per ticket, \nfor a mod without an override. This is the maximum number of chunks a single ticket can force.");
        temp.setLanguageKey("forge.configgui.maximumChunksPerTicket");
        temp.setMinValue(0);
        defaultMaxChunks = temp.getInt(25);
        propOrder.add("maximumChunksPerTicket");
        temp = config.get("defaults", "maximumTicketCount", 200);
        temp.setComment("The default maximum ticket count for a mod which does not have an override\nin this file. This is the number of chunk loading requests a mod is allowed to make.");
        temp.setLanguageKey("forge.configgui.maximumTicketCount");
        temp.setMinValue(0);
        defaultMaxCount = temp.getInt(200);
        propOrder.add("maximumTicketCount");
        temp = config.get("defaults", "playerTicketCount", 500);
        temp.setComment("The number of tickets a player can be assigned instead of a mod. This is shared across all mods and it is up to the mods to use it.");
        temp.setLanguageKey("forge.configgui.playerTicketCount");
        temp.setMinValue(0);
        playerTicketLength = temp.getInt(500);
        propOrder.add("playerTicketCount");
        temp = config.get("defaults", "dormantChunkCacheSize", 0);
        temp.setComment("Unloaded chunks can first be kept in a dormant cache for quicker\nloading times. Specify the size (in chunks) of that cache here");
        temp.setLanguageKey("forge.configgui.dormantChunkCacheSize");
        temp.setMinValue(0);
        dormantChunkCacheSize = temp.getInt(0);
        propOrder.add("dormantChunkCacheSize");
        FMLLog.log.info(Message.getString("fml.log.6"), (Object)temp.getInt(0));
        temp = config.get("defaults", "asyncChunkLoading", true);
        temp.setComment("Load chunks asynchronously for players, reducing load on the server thread.\nCan be disabled to help troubleshoot chunk loading issues.");
        temp.setLanguageKey("forge.configgui.asyncChunkLoading");
        asyncChunkLoading = temp.getBoolean(true);
        propOrder.add("asyncChunkLoading");
        config.setCategoryPropertyOrder("defaults", propOrder);
        config.addCustomCategoryComment("forge", "Sample mod specific control section.\nCopy this section and rename the with the modid for the mod you wish to override.\nA value of zero in either entry effectively disables any chunkloading capabilities\nfor that mod");
        temp = config.get("forge", "maximumTicketCount", 200);
        temp.setComment("Maximum ticket count for the mod. Zero disables chunkloading capabilities.");
        temp = config.get("forge", "maximumChunksPerTicket", 25);
        temp.setComment("Maximum chunks per ticket for the mod.");
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("forge") || mod.equals("defaults")) continue;
            config.get(mod, "maximumTicketCount", 200).setLanguageKey("forge.configgui.maximumTicketCount").setMinValue(0);
            config.get(mod, "maximumChunksPerTicket", 25).setLanguageKey("forge.configgui.maximumChunksPerTicket").setMinValue(0);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    public static ConfigCategory getDefaultsCategory() {
        return config.getCategory("defaults");
    }

    public static List<ConfigCategory> getModCategories() {
        ArrayList<ConfigCategory> list = new ArrayList<ConfigCategory>();
        for (String mod : config.getCategoryNames()) {
            if (mod.equals("forge") || mod.equals("defaults")) continue;
            list.add(config.getCategory(mod));
        }
        return list;
    }

    @Nullable
    public static ConfigCategory getConfigFor(Object mod) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            return config.getCategory(container.getModId());
        }
        return null;
    }

    public static void addConfigProperty(Object mod, String propertyName, String value, Property.Type type) {
        ModContainer container = ForgeChunkManager.getContainer(mod);
        if (container != null) {
            ConfigCategory cat = config.getCategory(container.getModId());
            Property prop = new Property(propertyName, value, type).setLanguageKey("forge.configgui." + propertyName);
            if (type == Property.Type.INTEGER) {
                prop.setMinValue(0);
            }
            cat.put(propertyName, prop);
        }
    }

    static {
        tickets = new MapMaker().weakKeys().makeMap();
        ticketConstraints = Maps.newHashMap();
        chunkConstraints = Maps.newHashMap();
        playerTickets = HashMultimap.create();
        callbacks = Maps.newHashMap();
        forcedChunks = Collections.synchronizedMap(new WeakHashMap());
        pendingEntities = HashBiMap.create();
        dormantChunkCache = new MapMaker().weakKeys().makeMap();
        MOD_PROP_ORDER = new ArrayList<String>(2);
        warnedMods = Sets.newHashSet();
        MOD_PROP_ORDER.add("maximumTicketCount");
        MOD_PROP_ORDER.add("maximumChunksPerTicket");
    }

    public static class UnforceChunkEvent
    extends Event {
        private final Ticket ticket;
        private final amn location;

        public UnforceChunkEvent(Ticket ticket, amn location) {
            this.ticket = ticket;
            this.location = location;
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        public amn getLocation() {
            return this.location;
        }
    }

    public static class ForceChunkEvent
    extends Event {
        private final Ticket ticket;
        private final amn location;

        public ForceChunkEvent(Ticket ticket, amn location) {
            this.ticket = ticket;
            this.location = location;
        }

        public Ticket getTicket() {
            return this.ticket;
        }

        public amn getLocation() {
            return this.location;
        }
    }

    public static class Ticket {
        private String modId;
        private Type ticketType;
        private LinkedHashSet<amn> requestedChunks;
        private fy modData;
        public final amu world;
        private int maxDepth;
        private int entityChunkX;
        private int entityChunkZ;
        private vg entity;
        private String player;

        Ticket(String modId, Type type, amu world) {
            this.modId = modId;
            this.ticketType = type;
            this.world = world;
            this.maxDepth = ForgeChunkManager.getMaxChunkDepthFor(modId);
            this.requestedChunks = Sets.newLinkedHashSet();
        }

        Ticket(String modId, Type type, amu world, String player) {
            this(modId, type, world);
            if (player == null) {
                FMLLog.log.error("Attempt to create a player ticket without a valid player");
                throw new RuntimeException();
            }
            this.player = player;
        }

        public void setChunkListDepth(int depth) {
            if (depth > ForgeChunkManager.getMaxChunkDepthFor(this.modId) || depth <= 0 && ForgeChunkManager.getMaxChunkDepthFor(this.modId) > 0) {
                FMLLog.log.warn("The mod {} tried to modify the chunk ticket depth to: {}, its allowed maximum is: {}", (Object)this.modId, (Object)depth, (Object)ForgeChunkManager.getMaxChunkDepthFor(this.modId));
            } else {
                this.maxDepth = depth;
            }
        }

        public int getChunkListDepth() {
            return this.maxDepth;
        }

        public int getMaxChunkListDepth() {
            return ForgeChunkManager.getMaxChunkDepthFor(this.modId);
        }

        public void bindEntity(vg entity) {
            if (this.ticketType != Type.ENTITY) {
                throw new RuntimeException("Cannot bind an entity to a non-entity ticket");
            }
            this.entity = entity;
        }

        public fy getModData() {
            if (this.modData == null) {
                this.modData = new fy();
            }
            return this.modData;
        }

        public vg getEntity() {
            return this.entity;
        }

        public boolean isPlayerTicket() {
            return this.player != null;
        }

        public String getPlayerName() {
            return this.player;
        }

        public String getModId() {
            return this.modId;
        }

        public Type getType() {
            return this.ticketType;
        }

        public ImmutableSet<amn> getChunkList() {
            return ImmutableSet.copyOf(this.requestedChunks);
        }
    }

    public static enum Type {
        NORMAL,
        ENTITY;

    }

    public static interface PlayerOrderedLoadingCallback
    extends LoadingCallback {
        public ListMultimap<String, Ticket> playerTicketsLoaded(ListMultimap<String, Ticket> var1, amu var2);
    }

    public static interface OrderedLoadingCallback
    extends LoadingCallback {
        public List<Ticket> ticketsLoaded(List<Ticket> var1, amu var2, int var3);
    }

    public static interface LoadingCallback {
        public void ticketsLoaded(List<Ticket> var1, amu var2);
    }

    private static class ChunkEntry {
        public final axw chunk;
        public final fy nbt;

        public ChunkEntry(axw chunk) {
            this.chunk = chunk;
            this.nbt = new fy();
        }
    }
}

