/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mohistmc.MohistMC;
import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.NetworkUtil;
import com.mohistmc.util.i18n.Message;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Stream;

public class UpdateUtils {
    private static int percentage = 0;

    public static void versionCheck() {
        System.out.println(Message.getString("update.check"));
        System.out.println(Message.getString("update.stopcheck"));
        try {
            JsonElement root = new JsonParser().parse((Reader)new InputStreamReader(NetworkUtil.getInput("https://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/api/json")));
            String jar_sha = MohistMC.getVersion();
            String build_number = "1.12.2-" + root.getAsJsonObject().get("number").toString();
            String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(root.getAsJsonObject().get("timestamp").toString())));
            if (jar_sha.equals(build_number)) {
                System.out.println(Message.getFormatString("update.latest", new Object[]{"1.9", jar_sha, build_number}));
            } else {
                System.out.println(Message.getFormatString("update.detect", new Object[]{build_number, jar_sha, time}));
                if (MohistConfigUtil.bMohist("check_update_auto_download")) {
                    UpdateUtils.downloadFile("mhttps://ci.codemc.io/job/Mohist-Community/job/Mohist-1.12.2/lastSuccessfulBuild/artifact/projects/mohist/build/libs/mohist-" + build_number + "-server.jar", new File(UpdateUtils.getMohistJar().getName()));
                }
            }
        }
        catch (Throwable e) {
            System.out.println(Message.getString("check.update.noci"));
        }
    }

    public static void downloadFile(String URL2, final File f) throws Exception {
        URLConnection conn = NetworkUtil.getConn(URL2.replace("mhttps", "https"));
        System.out.println(Message.getFormatString("file.download.start", new Object[]{f.getName(), UpdateUtils.getSize(conn.getContentLength())}));
        final ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
        FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        final int fS = conn.getContentLength();
        final Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (rbc.isOpen()) {
                    if (percentage != Math.round((float)f.length() / (float)fS * 100.0f) && percentage < 100) {
                        System.out.println(Message.getFormatString("file.download.percentage", new Object[]{f.getName(), percentage}));
                    }
                    percentage = Math.round((float)f.length() / (float)fS * 100.0f);
                } else {
                    t.cancel();
                }
            }
        }, 3000L, 1000L);
        fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
        fc.close();
        rbc.close();
        if (URL2.startsWith("mhttps")) {
            UpdateUtils.restartServer(new ArrayList<String>(Arrays.asList("java", "-jar", UpdateUtils.getMohistJar().getName())));
        } else {
            System.out.println(Message.getFormatString("file.download.ok", new Object[]{f.getName()}));
        }
    }

    public static File getMohistJar() {
        try {
            String path = UpdateUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            if (path.contains("!/")) {
                path = path.split("!/")[0].split("jar:file:/")[1];
            }
            return new File(path);
        }
        catch (Exception e) {
            System.out.println("Can't found the Mohist jar !");
            return null;
        }
    }

    public static HashMap<String, String> getLibs() {
        List<String> allLibsLines;
        HashMap<String, String> libsToDl = new HashMap<String, String>();
        HashMap<String, String> mavenList = new HashMap<String, String>();
        try {
            allLibsLines = Files.readAllLines(new File("libraries", "mohist_libraries.json").toPath());
        }
        catch (IOException e) {
            return null;
        }
        String[] joined = String.join((CharSequence)" ", allLibsLines).split("}");
        for (int i2 = 0; i2 < joined.length - 1; ++i2) {
            String thePath = "";
            String theMd5 = "nomd5";
            String t = joined[i2];
            if (!t.contains("\"mavenlist\"")) {
                String theLink;
                String[] s = t.split(",");
                if (!t.contains("\"maven\"")) {
                    theLink = UpdateUtils.getElement(s, "link");
                    for (Object o : mavenList.keySet()) {
                        if (!theLink.contains(o.toString())) continue;
                        theLink = theLink.replace(o + " + ", (CharSequence)mavenList.get(o.toString()));
                    }
                    try {
                        thePath = new URL(theLink).getPath();
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else {
                    String[] name = UpdateUtils.getElement(s, "name").split(":");
                    String nameTransform = name[0].replaceAll("\\.", "/") + "/" + name[1].replaceAll("\\.", "/") + "/" + name[2] + "/" + name[1] + "-" + name[2] + ".jar";
                    theLink = UpdateUtils.getElement(s, "maven") + "/" + nameTransform;
                    thePath = nameTransform;
                }
                if (t.contains("\"md5\"")) {
                    theMd5 = UpdateUtils.getElement(s, "md5");
                }
                if (t.contains("\"path\"")) {
                    thePath = UpdateUtils.getElement(s, "path");
                }
                if (thePath.startsWith("/")) {
                    thePath = thePath.substring(1);
                }
                if (thePath.startsWith("libraries")) {
                    thePath = thePath.replaceFirst("libraries", "");
                }
                if (!thePath.endsWith(".jar")) {
                    thePath = thePath + "/" + theLink.split("/")[theLink.split("/").length - 1];
                }
                if (!t.contains("\"link\"")) {
                    theLink = "no";
                }
                libsToDl.put(theLink + "*" + thePath, theMd5);
                continue;
            }
            t = t.split("\"mavenlist\":\\{")[1].replaceAll(" ", "");
            for (int j = 0; j < t.split(",").length; ++j) {
                String e1 = t.split(",")[j];
                String[] e2 = e1.split("\":\"");
                String mvName = e2[0].substring(e2[0].indexOf("\"") + 1);
                String mvLink = e2[1].split("\"")[0];
                if (!mvLink.contains("http") || !mvLink.contains("://")) continue;
                mavenList.put(mvName, mvLink + "/");
            }
        }
        return libsToDl;
    }

    private static String getElement(String[] s, String what) {
        for (String value : s) {
            if (!value.contains(what)) continue;
            return value.substring(value.indexOf(what)).split("\"")[2];
        }
        return "nothing";
    }

    public static void restartServer(ArrayList<String> cmd) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        Process process = processBuilder.start();
        process.waitFor();
        Thread.sleep(2000L);
        System.exit(0);
    }

    public static String getSize(long size) {
        return size >= 0x100000L ? (float)size / 1048576.0f + "MB" : (size >= 1024L ? (float)size / 1024.0f + " KB" : size + " B");
    }

    public static long getSizeOfDirectory(File path) throws IOException {
        return ((Stream)Files.walk(path.toPath(), new FileVisitOption[0]).parallel()).filter(p2 -> !p2.toFile().isDirectory()).count();
    }
}

