/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.forge;

import com.mohistmc.MohistMC;
import com.mohistmc.api.ItemAPI;
import com.mohistmc.entity.CraftCustomEntity;
import com.mohistmc.util.i18n.Message;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.craftbukkit.v1_12_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_12_R1.potion.CraftPotionEffectType;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.permissions.DefaultPermissions;

public class ForgeInjectBukkit {
    public static void init() {
        ForgeInjectBukkit.addEnumMaterialInItems();
        ForgeInjectBukkit.addEnumMaterialsInBlocks();
        ForgeInjectBukkit.addEnumEnchantment();
        ForgeInjectBukkit.addEnumPotion();
        ForgeInjectBukkit.addEnumBiome();
        ForgeInjectBukkit.addEnumPattern();
        ForgeInjectBukkit.addEnumEntity();
    }

    public static void addEnumMaterialInItems() {
        for (Map.Entry<nf, ain> entry : ForgeRegistries.ITEMS.getEntries()) {
            ain item;
            int id;
            nf key = entry.getKey();
            if (key.b().equals("minecraft")) continue;
            String[] res = key.toString().split(":");
            String modid = Material.normalizeName(res[0]);
            String materialName = Material.normalizeName(key.toString());
            Material material = Material.addMaterial(materialName, id = ain.a((ain)(item = entry.getValue())), false);
            if (material == null) continue;
            ItemAPI.MODNAME_MAP.put(material.name(), modid);
            ItemAPI.MODID_MAP.put(id, modid);
            MohistMC.LOGGER.debug("Save: " + Message.getFormatString("injected.item", new Object[]{material.name(), String.valueOf(material.getId()), String.valueOf(ItemAPI.getBukkit(material).getDurability())}));
        }
    }

    public static void addEnumMaterialsInBlocks() {
        for (Map.Entry<nf, aow> entry : ForgeRegistries.BLOCKS.getEntries()) {
            aow block;
            int id;
            nf key = entry.getKey();
            if (key.b().equals("minecraft")) continue;
            String[] res = key.toString().split(":");
            String modid = Material.normalizeName(res[0]);
            String materialName = Material.normalizeName(key.toString());
            Material material = Material.addMaterial(materialName, id = aow.a((aow)(block = entry.getValue())), true);
            if (material == null) continue;
            ItemAPI.MODNAME_MAP.put(material.name(), modid);
            ItemAPI.MODID_MAP.put(id, modid);
            MohistMC.LOGGER.debug("Save: " + Message.getFormatString("injected.block", new Object[]{material.name(), String.valueOf(material.getBlockID())}));
        }
        for (Material material : Material.values()) {
            int id = material.getId();
            if (id >= 256) continue;
            Material.blockById[id] = material;
        }
    }

    public static void addEnumEnchantment() {
        for (Map.Entry<nf, alk> entry : ForgeRegistries.ENCHANTMENTS.getEntries()) {
            Enchantment.registerEnchantment(new CraftEnchantment(entry.getValue()));
        }
        Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumPotion() {
        for (Map.Entry<nf, uz> entry : ForgeRegistries.POTIONS.getEntries()) {
            CraftPotionEffectType pet = new CraftPotionEffectType(entry.getValue());
            PotionEffectType.registerPotionEffectType(pet);
        }
        PotionEffectType.stopAcceptingRegistrations();
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        for (Map.Entry<nf, anh> entry : ForgeRegistries.BIOMES.getEntries()) {
            String biomeName = entry.getKey().a().toUpperCase(Locale.ENGLISH);
            if (entry.getKey().b().equals("minecraft") || map.contains(biomeName)) continue;
            map.add(biomeName);
            EnumHelper.addEnum(Biome.class, biomeName, new Class[0], new Object[0]);
        }
        map.clear();
    }

    public static void addEnumPattern() {
        Map PATTERN_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(PatternType.class, null, "byString");
        for (avg bannerpattern : avg.values()) {
            String p_i47246_3_ = bannerpattern.name();
            String hashname = bannerpattern.b();
            if (PatternType.getByIdentifier(hashname) != null) continue;
            PatternType patternType = EnumHelper.addEnum(PatternType.class, p_i47246_3_, new Class[]{String.class}, new Object[]{hashname});
            PATTERN_MAP.put(hashname, patternType);
        }
    }

    public static World.Environment addEnumEnvironment(int id, String name) {
        return EnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
    }

    public static WorldType addEnumWorldType(String name) {
        WorldType worldType = EnumHelper.addEnum(WorldType.class, name, new Class[]{String.class}, new Object[]{name});
        Map BY_NAME = (Map)ObfuscationReflectionHelper.getPrivateValue(WorldType.class, null, "BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static void addEnumEntity() {
        Map NAME_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityType.class, null, "NAME_MAP");
        Map ID_MAP = (Map)ObfuscationReflectionHelper.getPrivateValue(EntityType.class, null, "ID_MAP");
        for (Map.Entry<String, Class<? extends vg>> entity : EntityRegistry.entityClassMap.entrySet()) {
            String name = entity.getKey();
            String entityType = name.toUpperCase();
            int typeId = GameData.getEntityRegistry().getID(EntityRegistry.getEntry(entity.getValue()));
            EntityType bukkitType = EnumHelper.addEnum(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, new Object[]{name, CraftCustomEntity.class, typeId, false});
            NAME_MAP.put(name.toLowerCase(), bukkitType);
            ID_MAP.put((short)typeId, bukkitType);
        }
    }

    public static void registerDefaultPermission(String name, DefaultPermissionLevel level, String desc) {
        PermissionDefault permissionDefault;
        switch (level) {
            case ALL: {
                permissionDefault = PermissionDefault.TRUE;
                break;
            }
            case OP: {
                permissionDefault = PermissionDefault.OP;
                break;
            }
            default: {
                permissionDefault = PermissionDefault.FALSE;
            }
        }
        Permission permission = new Permission(name, desc, permissionDefault);
        DefaultPermissions.registerPermission(permission, false);
    }
}

