/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery.json;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.discovery.json.ASMInfo;
import org.objectweb.asm.Type;

public class JsonAnnotationLoader {
    public static final String ANNOTATION_JSON = "META-INF/fml_cache_annotation.json";
    private static final Gson GSON = new GsonBuilder().create();
    private static final java.lang.reflect.Type INFO_TABLE = new TypeToken<Map<String, ASMInfo>>(){}.getType();

    public static Multimap<String, ASMDataTable.ASMData> loadJson(InputStream data, ModCandidate candidate, ASMDataTable table) {
        Map map = (Map)GSON.fromJson((Reader)new InputStreamReader(data, StandardCharsets.UTF_8), INFO_TABLE);
        HashMultimap ret = HashMultimap.create();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).startsWith("META-INF/") || ((String)entry.getKey()).endsWith("$")) continue;
            ASMInfo asm_info = (ASMInfo)entry.getValue();
            if (asm_info.interfaces != null) {
                for (String type : asm_info.interfaces) {
                    table.addASMData(candidate, type, asm_info.name, null, null);
                    ret.put((Object)type, (Object)new ASMDataTable.ASMData(candidate, type, asm_info.name, null, null));
                }
            }
            String owner_name = asm_info.name.replace('/', '.');
            if (asm_info.annotations == null) continue;
            for (ASMInfo.Annotation anno : asm_info.annotations) {
                String name = anno.name.indexOf(59) > 0 ? Type.getType((String)anno.name).getClassName() : anno.name;
                String target = anno.target != null && (anno.type == ASMInfo.TargetType.CLASS || anno.type == ASMInfo.TargetType.SUBTYPE) ? anno.target.replace('/', '.') : anno.target;
                table.addASMData(candidate, name, owner_name, target, anno.getValues(asm_info));
                ret.put((Object)name, (Object)new ASMDataTable.ASMData(candidate, name, owner_name, target, anno.getValues(asm_info)));
            }
        }
        return ret;
    }
}

