/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.network.download;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.util.HashMap;

public class DownloadLibraries {
    static HashMap<String, String> fail = new HashMap();

    public static void run() throws Exception {
        String str;
        System.out.println(Message.getString("libraries.checking.start"));
        String url = "https://www.mgazul.cn/";
        if (Message.isCN()) {
            url = "https://mohist-community.gitee.io/mohistdown/";
        }
        BufferedReader b2 = new BufferedReader(new InputStreamReader(DownloadLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b2.readLine()) != null) {
            File file;
            String[] args = str.split("\\|");
            if (args.length != 2 || (file = new File(args[0])).exists() && MD5Util.md5CheckSum(file, args[1]) || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName())) continue;
            file.getParentFile().mkdirs();
            String u = url + args[0];
            System.out.println(Message.getString("libraries.global.percentage") + String.valueOf((float)UpdateUtils.getSizeOfDirectory(new File("libraries")) / 35.0f * 100.0f).substring(0, 2).replace(".", "") + "%");
            try {
                UpdateUtils.downloadFile(u, file);
                if (!file.getName().equals("minecraft_server.1.12.2.jar")) {
                    JarLoader.loadjar(new JarLoader((URLClassLoader)ClassLoader.getSystemClassLoader()), file.getParent());
                }
                if (!fail.containsKey(u)) continue;
                fail.remove(u);
            }
            catch (Exception e) {
                System.out.println(Message.getFormatString("file.download.nook", new Object[]{u}));
                file.delete();
                fail.put(u, file.getAbsolutePath());
            }
        }
        b2.close();
        if (!fail.isEmpty()) {
            DownloadLibraries.run();
        } else {
            System.out.println(Message.getString("libraries.checking.end"));
            if (!fail.isEmpty()) {
                System.out.println(Message.getString("libraries.cant.start.server"));
                for (String lib : fail.keySet()) {
                    System.out.println("Link : " + lib + "\nPath : " + fail.get(lib) + "\n");
                }
                System.exit(0);
            }
        }
    }
}

