/*
 * Decompiled with CFR 0.152.
 */
package red.mohist.configuration;

import java.util.List;
import red.mohist.api.ServerAPI;
import red.mohist.configuration.BoolSetting;
import red.mohist.configuration.ConfigBase;
import red.mohist.configuration.IntSetting;

public class WorldConfig {
    private final String worldName;
    public ConfigBase baseConfig;
    private boolean verbose;

    public WorldConfig(String worldName, ConfigBase configFile) {
        this.worldName = worldName.toLowerCase();
        this.baseConfig = configFile;
    }

    public void save() {
        this.baseConfig.save();
    }

    private void log(String s) {
        if (this.verbose) {
            ServerAPI.getNMSServer().e(s);
        }
    }

    public void set(String path, Object val) {
        this.baseConfig.config.set(path, val);
    }

    public boolean isBoolean(String path) {
        return this.baseConfig.config.isBoolean(path);
    }

    public boolean getBoolean(String path, boolean def) {
        if (this.baseConfig.settings.get("world-settings.default." + path) == null) {
            this.baseConfig.settings.put("world-settings.default." + path, new BoolSetting(this.baseConfig, "world-settings.default." + path, def, ""));
        }
        this.baseConfig.config.addDefault("world-settings.default." + path, def);
        return this.baseConfig.config.getBoolean("world-settings." + this.worldName + "." + path, this.baseConfig.config.getBoolean("world-settings.default." + path));
    }

    private double getDouble(String path, double def) {
        this.baseConfig.config.addDefault("world-settings.default." + path, def);
        return this.baseConfig.config.getDouble("world-settings." + this.worldName + "." + path, this.baseConfig.config.getDouble("world-settings.default." + path));
    }

    public int getInt(String path, int def) {
        if (this.baseConfig.settings.get("world-settings.default." + path) == null) {
            this.baseConfig.settings.put("world-settings.default." + path, new IntSetting(this.baseConfig, "world-settings.default." + path, def, ""));
        }
        this.baseConfig.config.addDefault("world-settings.default." + path, def);
        return this.baseConfig.config.getInt("world-settings." + this.worldName + "." + path, this.baseConfig.config.getInt("world-settings.default." + path));
    }

    private <T> List getList(String path, T def) {
        this.baseConfig.config.addDefault("world-settings.default." + path, def);
        return this.baseConfig.config.getList("world-settings." + this.worldName + "." + path, this.baseConfig.config.getList("world-settings.default." + path));
    }

    private String getString(String path, String def) {
        this.baseConfig.config.addDefault("world-settings.default." + path, def);
        return this.baseConfig.config.getString("world-settings." + this.worldName + "." + path, this.baseConfig.config.getString("world-settings.default." + path));
    }
}

