/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava;

import libnoiseforjava.Interp;
import libnoiseforjava.VectorTable;

public class NoiseGen {
    static final int X_NOISE_GEN = 1619;
    static final int Y_NOISE_GEN = 31337;
    static final int Z_NOISE_GEN = 6971;
    static final int SEED_NOISE_GEN = 1013;
    static final int SHIFT_NOISE_GEN = 8;

    public static double GradientCoherentNoise3D(double x, double y, double z, int seed, NoiseQuality noiseQuality) {
        int x0 = x > 0.0 ? (int)x : (int)x - 1;
        int x1 = x0 + 1;
        int y0 = y > 0.0 ? (int)y : (int)y - 1;
        int y1 = y0 + 1;
        int z0 = z > 0.0 ? (int)z : (int)z - 1;
        int z1 = z0 + 1;
        double xs = 0.0;
        double ys = 0.0;
        double zs = 0.0;
        switch (noiseQuality) {
            case QUALITY_FAST: {
                xs = x - (double)x0;
                ys = y - (double)y0;
                zs = z - (double)z0;
                break;
            }
            case QUALITY_STD: {
                xs = Interp.SCurve3(x - (double)x0);
                ys = Interp.SCurve3(y - (double)y0);
                zs = Interp.SCurve3(z - (double)z0);
                break;
            }
            case QUALITY_BEST: {
                xs = Interp.SCurve5(x - (double)x0);
                ys = Interp.SCurve5(y - (double)y0);
                zs = Interp.SCurve5(z - (double)z0);
            }
        }
        double n0 = NoiseGen.GradientNoise3D(x, y, z, x0, y0, z0, seed);
        double n1 = NoiseGen.GradientNoise3D(x, y, z, x1, y0, z0, seed);
        double ix0 = Interp.linearInterp(n0, n1, xs);
        n0 = NoiseGen.GradientNoise3D(x, y, z, x0, y1, z0, seed);
        n1 = NoiseGen.GradientNoise3D(x, y, z, x1, y1, z0, seed);
        double ix1 = Interp.linearInterp(n0, n1, xs);
        double iy0 = Interp.linearInterp(ix0, ix1, ys);
        n0 = NoiseGen.GradientNoise3D(x, y, z, x0, y0, z1, seed);
        n1 = NoiseGen.GradientNoise3D(x, y, z, x1, y0, z1, seed);
        ix0 = Interp.linearInterp(n0, n1, xs);
        n0 = NoiseGen.GradientNoise3D(x, y, z, x0, y1, z1, seed);
        n1 = NoiseGen.GradientNoise3D(x, y, z, x1, y1, z1, seed);
        ix1 = Interp.linearInterp(n0, n1, xs);
        double iy1 = Interp.linearInterp(ix0, ix1, ys);
        return Interp.linearInterp(iy0, iy1, zs);
    }

    public static double GradientNoise3D(double fx, double fy2, double fz, int ix, int iy, int iz, int seed) {
        VectorTable vectorTable = new VectorTable();
        int vectorIndex = 1619 * ix + 31337 * iy + 6971 * iz + 1013 * seed & 0xFFFFFFFF;
        vectorIndex ^= vectorIndex >> 8;
        double xvGradient = vectorTable.getRandomVectors(vectorIndex &= 0xFF, 0);
        double yvGradient = vectorTable.getRandomVectors(vectorIndex, 1);
        double zvGradient = vectorTable.getRandomVectors(vectorIndex, 2);
        double xvPoint = fx - (double)ix;
        double yvPoint = fy2 - (double)iy;
        double zvPoint = fz - (double)iz;
        return (xvGradient * xvPoint + yvGradient * yvPoint + zvGradient * zvPoint) * 2.12;
    }

    public static int IntValueNoise3D(int x, int y, int z, int seed) {
        int n = 1619 * x + 31337 * y + 6971 * z + 1013 * seed & Integer.MAX_VALUE;
        n = n >> 13 ^ n;
        return n * (n * n * 60493 + 19990303) + 1376312589 & Integer.MAX_VALUE;
    }

    public static double ValueCoherentNoise3D(double x, double y, double z, int seed, NoiseQuality noiseQuality) {
        int x0 = x > 0.0 ? (int)x : (int)x - 1;
        int x1 = x0 + 1;
        int y0 = y > 0.0 ? (int)y : (int)y - 1;
        int y1 = y0 + 1;
        int z0 = z > 0.0 ? (int)z : (int)z - 1;
        int z1 = z0 + 1;
        double xs = 0.0;
        double ys = 0.0;
        double zs = 0.0;
        switch (noiseQuality) {
            case QUALITY_FAST: {
                xs = x - (double)x0;
                ys = y - (double)y0;
                zs = z - (double)z0;
                break;
            }
            case QUALITY_STD: {
                xs = Interp.SCurve3(x - (double)x0);
                ys = Interp.SCurve3(y - (double)y0);
                zs = Interp.SCurve3(z - (double)z0);
                break;
            }
            case QUALITY_BEST: {
                xs = Interp.SCurve5(x - (double)x0);
                ys = Interp.SCurve5(y - (double)y0);
                zs = Interp.SCurve5(z - (double)z0);
            }
        }
        double n0 = NoiseGen.ValueNoise3D(x0, y0, z0, seed);
        double n1 = NoiseGen.ValueNoise3D(x1, y0, z0, seed);
        double ix0 = Interp.linearInterp(n0, n1, xs);
        n0 = NoiseGen.ValueNoise3D(x0, y1, z0, seed);
        n1 = NoiseGen.ValueNoise3D(x1, y1, z0, seed);
        double ix1 = Interp.linearInterp(n0, n1, xs);
        double iy0 = Interp.linearInterp(ix0, ix1, ys);
        n0 = NoiseGen.ValueNoise3D(x0, y0, z1, seed);
        n1 = NoiseGen.ValueNoise3D(x1, y0, z1, seed);
        ix0 = Interp.linearInterp(n0, n1, xs);
        n0 = NoiseGen.ValueNoise3D(x0, y1, z1, seed);
        n1 = NoiseGen.ValueNoise3D(x1, y1, z1, seed);
        ix1 = Interp.linearInterp(n0, n1, xs);
        double iy1 = Interp.linearInterp(ix0, ix1, ys);
        return Interp.linearInterp(iy0, iy1, zs);
    }

    public static double ValueNoise3D(int x, int y, int z, int seed) {
        return 1.0 - (double)NoiseGen.IntValueNoise3D(x, y, z, seed) / 1.073741824E9;
    }

    public static double MakeInt32Range(double n) {
        if (n >= 1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) - 1.073741824E9;
        }
        if (n <= -1.073741824E9) {
            return 2.0 * (n % 1.073741824E9) + 1.073741824E9;
        }
        return n;
    }

    public static enum NoiseQuality {
        QUALITY_FAST,
        QUALITY_STD,
        QUALITY_BEST;

    }
}

