/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.model;

import libnoiseforjava.module.ModuleBase;

public class Line {
    boolean attenuate = true;
    ModuleBase module;
    double x0;
    double x1;
    double y0;
    double y1;
    double z0;
    double z1;

    Line() {
        this.module = new ModuleBase(1);
        this.x0 = 0.0;
        this.x1 = 1.0;
        this.y0 = 0.0;
        this.y1 = 1.0;
        this.z0 = 0.0;
        this.z1 = 1.0;
    }

    Line(ModuleBase module) {
        this.module = module;
        this.x0 = 0.0;
        this.x1 = 1.0;
        this.y0 = 0.0;
        this.y1 = 1.0;
        this.z0 = 0.0;
        this.z1 = 1.0;
    }

    public double getValue(double p2) {
        assert (this.module != null);
        double x = (this.x1 - this.x0) * p2 + this.x0;
        double y = (this.y1 - this.y0) * p2 + this.y0;
        double z = (this.z1 - this.z0) * p2 + this.z0;
        double value = this.module.getValue(x, y, z);
        if (this.attenuate) {
            return p2 * (1.0 - p2) * 4.0 * value;
        }
        return value;
    }

    public boolean getAttenuate() {
        return this.attenuate;
    }

    public ModuleBase getModule() {
        assert (this.module != null);
        return this.module;
    }

    public void setAttenuate(boolean att) {
        this.attenuate = att;
    }

    public void setEndPoint(double x, double y, double z) {
        this.x1 = x;
        this.y1 = y;
        this.z1 = z;
    }

    public void setModule(ModuleBase module) {
        this.module = module;
    }

    public void setStartPoint(double x, double y, double z) {
        this.x0 = x;
        this.y0 = y;
        this.z0 = z;
    }

    public double getX0() {
        return this.x0;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY0() {
        return this.y0;
    }

    public double getY1() {
        return this.y1;
    }

    public double getZ0() {
        return this.z0;
    }

    public double getZ1() {
        return this.z1;
    }

    public void setX0(double x0) {
        this.x0 = x0;
    }

    public void setX1(double x1) {
        this.x1 = x1;
    }

    public void setY0(double y0) {
        this.y0 = y0;
    }

    public void setY1(double y1) {
        this.y1 = y1;
    }

    public void setZ0(double z0) {
        this.z0 = z0;
    }

    public void setZ1(double z1) {
        this.z1 = z1;
    }
}

