/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.NoiseGen;
import libnoiseforjava.module.ModuleBase;

public class Billow
extends ModuleBase {
    static final double DEFAULT_BILLOW_FREQUENCY = 1.0;
    static final double DEFAULT_BILLOW_LACUNARITY = 2.0;
    static final int DEFAULT_BILLOW_OCTAVE_COUNT = 6;
    static final double DEFAULT_BILLOW_PERSISTENCE = 0.5;
    static final NoiseGen.NoiseQuality DEFAULT_BILLOW_QUALITY = NoiseGen.NoiseQuality.QUALITY_STD;
    static final int DEFAULT_BILLOW_SEED = 0;
    static final int BILLOW_MAX_OCTAVE = 30;
    double frequency = 1.0;
    double lacunarity = 2.0;
    double persistence = 0.5;
    int octaveCount = 6;
    int seed = 0;
    NoiseGen.NoiseQuality noiseQuality = DEFAULT_BILLOW_QUALITY;

    public Billow() {
        super(0);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double value = 0.0;
        double signal = 0.0;
        double curPersistence = 1.0;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        for (int curOctave = 0; curOctave < this.octaveCount; ++curOctave) {
            double nx = NoiseGen.MakeInt32Range(x);
            double ny2 = NoiseGen.MakeInt32Range(y);
            double nz = NoiseGen.MakeInt32Range(z);
            int calcSeed = this.seed + curOctave & 0xFFFFFFFF;
            signal = NoiseGen.GradientCoherentNoise3D(nx, ny2, nz, calcSeed, this.noiseQuality);
            signal = 2.0 * Math.abs(signal) - 1.0;
            value += signal * curPersistence;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            curPersistence *= this.persistence;
        }
        return value += 0.5;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public double getPersistence() {
        return this.persistence;
    }

    public int getOctaveCount() {
        return this.octaveCount;
    }

    public int getSeed() {
        return this.seed;
    }

    public NoiseGen.NoiseQuality getNoiseQuality() {
        return this.noiseQuality;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
    }

    public void setOctaveCount(int octaveCount) {
        this.octaveCount = octaveCount;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public void setNoiseQuality(NoiseGen.NoiseQuality noiseQuality) {
        this.noiseQuality = noiseQuality;
    }
}

