/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.Interp;
import libnoiseforjava.Misc;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ControlPoint;
import libnoiseforjava.module.ModuleBase;

public class Curve
extends ModuleBase {
    int controlPointCount;
    ControlPoint[] controlPoints;

    public Curve(ModuleBase sourceModule) throws ExceptionInvalidParam {
        super(1);
        this.setSourceModule(0, sourceModule);
        this.controlPointCount = 0;
        this.controlPoints = new ControlPoint[1];
        this.controlPoints[0] = new ControlPoint(0.0, 0.0);
    }

    public void addControlPoint(double inputValue, double outputValue) throws ExceptionInvalidParam {
        int insertionPos = this.findInsertionPos(inputValue);
        this.insertAtPos(insertionPos, inputValue, outputValue);
    }

    public void clearAllControlPoints() {
        this.controlPoints = null;
        this.controlPointCount = 0;
    }

    public int findInsertionPos(double inputValue) throws ExceptionInvalidParam {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.controlPointCount && !(inputValue < this.controlPoints[insertionPos].inputValue); ++insertionPos) {
            if (inputValue != this.controlPoints[insertionPos].inputValue) continue;
            throw new ExceptionInvalidParam("Invalid Parameter in Curve");
        }
        return insertionPos;
    }

    @Override
    public double getValue(double x, double y, double z) {
        int indexPos;
        assert (this.sourceModules[0] != null);
        assert (this.controlPointCount >= 4);
        double sourceModuleValue = this.sourceModules[0].getValue(x, y, z);
        for (indexPos = 0; indexPos < this.controlPointCount && !(sourceModuleValue < this.controlPoints[indexPos].inputValue); ++indexPos) {
        }
        int index0 = Misc.ClampValue(indexPos - 2, 0, this.controlPointCount - 1);
        int index1 = Misc.ClampValue(indexPos - 1, 0, this.controlPointCount - 1);
        int index2 = Misc.ClampValue(indexPos, 0, this.controlPointCount - 1);
        int index3 = Misc.ClampValue(indexPos + 1, 0, this.controlPointCount - 1);
        if (index1 == index2) {
            return this.controlPoints[index1].outputValue;
        }
        double input0 = this.controlPoints[index1].inputValue;
        double input1 = this.controlPoints[index2].inputValue;
        double alpha = (sourceModuleValue - input0) / (input1 - input0);
        return Interp.cubicInterp(this.controlPoints[index0].outputValue, this.controlPoints[index1].outputValue, this.controlPoints[index2].outputValue, this.controlPoints[index3].outputValue, alpha);
    }

    public void insertAtPos(int insertionPos, double inputValue, double outputValue) {
        ControlPoint[] newControlPoints = new ControlPoint[this.controlPointCount + 1];
        for (int t = 0; t < this.controlPointCount + 1; ++t) {
            newControlPoints[t] = new ControlPoint();
        }
        for (int i2 = 0; i2 < this.controlPointCount; ++i2) {
            if (i2 < insertionPos) {
                newControlPoints[i2] = this.controlPoints[i2];
                continue;
            }
            newControlPoints[i2 + 1] = this.controlPoints[i2];
        }
        this.controlPoints = newControlPoints;
        ++this.controlPointCount;
        this.controlPoints[insertionPos].inputValue = inputValue;
        this.controlPoints[insertionPos].outputValue = outputValue;
    }
}

