/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.exception.ExceptionNoModule;

public class ModuleBase {
    public ModuleBase[] sourceModules;
    public int modulesRequired;

    public ModuleBase() {
        this.modulesRequired = 0;
    }

    public ModuleBase(int modulesRequired) {
        if (modulesRequired > 0) {
            this.sourceModules = new ModuleBase[modulesRequired];
            for (int i2 = 0; i2 < modulesRequired; ++i2) {
                this.sourceModules[i2] = new ModuleBase();
            }
        } else {
            this.sourceModules = null;
        }
        this.modulesRequired = modulesRequired;
    }

    public ModuleBase getSourceModule(int index) throws ExceptionNoModule {
        if (this.sourceModules != null) {
            if (index >= this.getSourceModuleCount() || index < 0 || this.sourceModules[index] == null) {
                throw new ExceptionNoModule("Could not retrieve a source module from a noise module.");
            }
            return this.sourceModules[index];
        }
        throw new ExceptionNoModule("Could not retrieve a source module from a noise module.");
    }

    public int getSourceModuleCount() {
        return this.modulesRequired;
    }

    public double getValue(double x, double y, double z) {
        return x;
    }

    public void setSourceModule(int index, ModuleBase sourceModule) throws ExceptionInvalidParam {
        if (this.sourceModules != null && (index >= this.getSourceModuleCount() || index < 0)) {
            throw new ExceptionInvalidParam("Invalid Parameter in ModuleBase");
        }
        this.sourceModules[index] = sourceModule;
    }
}

