/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.NoiseGen;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ModuleBase;

public class Perlin
extends ModuleBase {
    static final double DEFAULT_PERLIN_FREQUENCY = 1.0;
    static final double DEFAULT_PERLIN_LACUNARITY = 2.0;
    static final int DEFAULT_PERLIN_OCTAVE_COUNT = 6;
    static final double DEFAULT_PERLIN_PERSISTENCE = 0.5;
    static final NoiseGen.NoiseQuality DEFAULT_PERLIN_QUALITY = NoiseGen.NoiseQuality.QUALITY_STD;
    static final int DEFAULT_PERLIN_SEED = 0;
    static final int PERLIN_MAX_OCTAVE = 30;
    double frequency = 1.0;
    double lacunarity = 2.0;
    NoiseGen.NoiseQuality noiseQuality = DEFAULT_PERLIN_QUALITY;
    int octaveCount = 6;
    double persistence = 0.5;
    int seed = 0;

    public Perlin() {
        super(0);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double value = 0.0;
        double signal = 0.0;
        double curPersistence = 1.0;
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        for (int curOctave = 0; curOctave < this.octaveCount; ++curOctave) {
            double nx = NoiseGen.MakeInt32Range(x);
            double ny2 = NoiseGen.MakeInt32Range(y);
            double nz = NoiseGen.MakeInt32Range(z);
            int curSeed = this.seed + curOctave & 0xFFFFFFFF;
            signal = NoiseGen.GradientCoherentNoise3D(nx, ny2, nz, curSeed, this.noiseQuality);
            value += signal * curPersistence;
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            curPersistence *= this.persistence;
        }
        return value;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public NoiseGen.NoiseQuality getNoiseQuality() {
        return this.noiseQuality;
    }

    public int getOctaveCount() {
        return this.octaveCount;
    }

    public double getPersistence() {
        return this.persistence;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
    }

    public void setNoiseQuality(NoiseGen.NoiseQuality noiseQuality) {
        this.noiseQuality = noiseQuality;
    }

    public void setOctaveCount(int octaveCount) throws ExceptionInvalidParam {
        if (octaveCount < 1 || octaveCount > 30) {
            throw new ExceptionInvalidParam("Invalid parameter In Perlin Noise Module");
        }
        this.octaveCount = octaveCount;
    }

    public void setPersistence(double persistence) {
        this.persistence = persistence;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }
}

