/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.NoiseGen;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ModuleBase;

public class RidgedMulti
extends ModuleBase {
    static final double DEFAULT_RIDGED_FREQUENCY = 1.0;
    static final double DEFAULT_RIDGED_LACUNARITY = 2.0;
    static final int DEFAULT_RIDGED_OCTAVE_COUNT = 6;
    static final NoiseGen.NoiseQuality DEFAULT_RIDGED_QUALITY = NoiseGen.NoiseQuality.QUALITY_STD;
    static final int DEFAULT_RIDGED_SEED = 0;
    static final int RIDGED_MAX_OCTAVE = 30;
    double frequency = 1.0;
    double lacunarity = 2.0;
    NoiseGen.NoiseQuality noiseQuality;
    int octaveCount = 6;
    double[] spectralWeights = new double[30];
    int seed = 0;

    public RidgedMulti() {
        super(0);
        this.noiseQuality = DEFAULT_RIDGED_QUALITY;
        this.calcSpectralWeights();
    }

    public void calcSpectralWeights() {
        double h = 1.0;
        double frequency = 1.0;
        for (int i2 = 0; i2 < 30; ++i2) {
            this.spectralWeights[i2] = Math.pow(frequency, -h);
            frequency *= this.lacunarity;
        }
    }

    @Override
    public double getValue(double x, double y, double z) {
        x *= this.frequency;
        y *= this.frequency;
        z *= this.frequency;
        double signal = 0.0;
        double value = 0.0;
        double weight = 1.0;
        double offset = 1.0;
        double gain = 2.0;
        for (int curOctave = 0; curOctave < this.octaveCount; ++curOctave) {
            double nx = NoiseGen.MakeInt32Range(x);
            double ny2 = NoiseGen.MakeInt32Range(y);
            double nz = NoiseGen.MakeInt32Range(z);
            int curSeed = this.seed + curOctave & Integer.MAX_VALUE;
            signal = NoiseGen.GradientCoherentNoise3D(nx, ny2, nz, curSeed, this.noiseQuality);
            signal = Math.abs(signal);
            signal = offset - signal;
            signal *= signal;
            if ((weight = (signal *= weight) * gain) > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            value += signal * this.spectralWeights[curOctave];
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
        }
        return value * 1.25 - 1.0;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public NoiseGen.NoiseQuality getNoiseQuality() {
        return this.noiseQuality;
    }

    public int getOctaveCount() {
        return this.octaveCount;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
        this.calcSpectralWeights();
    }

    public void setNoiseQuality(NoiseGen.NoiseQuality noiseQuality) {
        this.noiseQuality = noiseQuality;
    }

    public void setOctaveCount(int octaveCount) throws ExceptionInvalidParam {
        if (octaveCount > 30) {
            throw new ExceptionInvalidParam("An invalid parameter was passed to a libnoise function or method.");
        }
        this.octaveCount = octaveCount;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public double[] getSpectralWeights() {
        return this.spectralWeights;
    }

    public void setSpectralWeights(double[] spectralWeights) {
        this.spectralWeights = spectralWeights;
    }
}

