/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ModuleBase;

public class RotatePoint
extends ModuleBase {
    static final double DEFAULT_ROTATE_X = 0.0;
    static final double DEFAULT_ROTATE_Y = 0.0;
    static final double DEFAULT_ROTATE_Z = 0.0;
    double x1Matrix;
    double x2Matrix;
    double x3Matrix;
    double xAngle;
    double y1Matrix;
    double y2Matrix;
    double y3Matrix;
    double yAngle;
    double z1Matrix;
    double z2Matrix;
    double z3Matrix;
    double zAngle;

    public RotatePoint(ModuleBase sourceModule) throws ExceptionInvalidParam {
        super(1);
        this.setSourceModule(0, sourceModule);
        this.setAngles(0.0, 0.0, 0.0);
    }

    @Override
    public double getValue(double x, double y, double z) {
        assert (this.sourceModules[0] != null);
        double nx = this.x1Matrix * x + this.y1Matrix * y + this.z1Matrix * z;
        double ny2 = this.x2Matrix * x + this.y2Matrix * y + this.z2Matrix * z;
        double nz = this.x3Matrix * x + this.y3Matrix * y + this.z3Matrix * z;
        return this.sourceModules[0].getValue(nx, ny2, nz);
    }

    public void setAngles(double xAngle, double yAngle, double zAngle) {
        double xCos = Math.cos(Math.toRadians(xAngle));
        double yCos = Math.cos(Math.toRadians(yAngle));
        double zCos = Math.cos(Math.toRadians(zAngle));
        double xSin = Math.sin(Math.toRadians(xAngle));
        double ySin = Math.sin(Math.toRadians(yAngle));
        double zSin = Math.sin(Math.toRadians(zAngle));
        this.x1Matrix = ySin * xSin * zSin + yCos * zCos;
        this.y1Matrix = xCos * zSin;
        this.z1Matrix = ySin * zCos - yCos * xSin * zSin;
        this.x2Matrix = ySin * xSin * zCos - yCos * zSin;
        this.y2Matrix = xCos * zCos;
        this.z2Matrix = -yCos * xSin * zCos - ySin * zSin;
        this.x3Matrix = -ySin * xCos;
        this.y3Matrix = xSin;
        this.z3Matrix = yCos * xCos;
        this.xAngle = xAngle;
        this.yAngle = yAngle;
        this.zAngle = zAngle;
    }

    public double getXAngle() {
        return this.xAngle;
    }

    public double getYAngle() {
        return this.yAngle;
    }

    public double getZAngle() {
        return this.zAngle;
    }

    public void setXAngle(double xAngle) {
        this.setAngles(xAngle, this.yAngle, this.zAngle);
    }

    public void SetYAngle(double yAngle) {
        this.setAngles(this.xAngle, yAngle, this.zAngle);
    }

    public void SetZAngle(double zAngle) {
        this.setAngles(this.xAngle, this.yAngle, zAngle);
    }
}

