/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.Interp;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.exception.ExceptionNoModule;
import libnoiseforjava.module.ModuleBase;

public class Select
extends ModuleBase {
    static final double DEFAULT_SELECT_EDGE_FALLOFF = 0.0;
    static final double DEFAULT_SELECT_LOWER_BOUND = -1.0;
    static final double DEFAULT_SELECT_UPPER_BOUND = 1.0;
    double edgeFalloff;
    double lowerBound;
    double upperBound;

    public Select(ModuleBase sourceModuleOne, ModuleBase sourceModuleTwo, ModuleBase sourceModuleThree) throws ExceptionInvalidParam {
        super(3);
        this.setSourceModule(0, sourceModuleOne);
        this.setSourceModule(1, sourceModuleTwo);
        this.setSourceModule(2, sourceModuleThree);
        this.edgeFalloff = 0.0;
        this.lowerBound = -1.0;
        this.upperBound = 1.0;
    }

    @Override
    public double getValue(double x, double y, double z) {
        assert (this.sourceModules[0] != null);
        assert (this.sourceModules[1] != null);
        assert (this.sourceModules[2] != null);
        double controlValue = this.sourceModules[2].getValue(x, y, z);
        if (this.edgeFalloff > 0.0) {
            if (controlValue < this.lowerBound - this.edgeFalloff) {
                return this.sourceModules[0].getValue(x, y, z);
            }
            if (controlValue < this.lowerBound + this.edgeFalloff) {
                double lowerCurve = this.lowerBound - this.edgeFalloff;
                double upperCurve = this.lowerBound + this.edgeFalloff;
                double alpha = Interp.SCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Interp.linearInterp(this.sourceModules[0].getValue(x, y, z), this.sourceModules[2].getValue(x, y, z), alpha);
            }
            if (controlValue < this.upperBound - this.edgeFalloff) {
                return this.sourceModules[1].getValue(x, y, z);
            }
            if (controlValue < this.upperBound + this.edgeFalloff) {
                double lowerCurve = this.upperBound - this.edgeFalloff;
                double upperCurve = this.upperBound + this.edgeFalloff;
                double alpha = Interp.SCurve3((controlValue - lowerCurve) / (upperCurve - lowerCurve));
                return Interp.linearInterp(this.sourceModules[1].getValue(x, y, z), this.sourceModules[0].getValue(x, y, z), alpha);
            }
            return this.sourceModules[0].getValue(x, y, z);
        }
        if (controlValue < this.lowerBound || controlValue > this.upperBound) {
            return this.sourceModules[0].getValue(x, y, z);
        }
        return this.sourceModules[1].getValue(x, y, z);
    }

    public void setBounds(double lowerBound, double upperBound) {
        assert (lowerBound < upperBound);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.setEdgeFalloff(this.edgeFalloff);
    }

    public void setEdgeFalloff(double edgeFalloff) {
        double boundSize = this.upperBound - this.lowerBound;
        edgeFalloff = edgeFalloff > boundSize / 2.0 ? boundSize / 2.0 : edgeFalloff;
    }

    public ModuleBase getControlModule() throws ExceptionNoModule {
        if (this.sourceModules == null || this.sourceModules[2] == null) {
            throw new ExceptionNoModule("Could not retrieve a source module from a noise module.");
        }
        return this.sourceModules[2];
    }

    public double getEdgeFalloff() {
        return this.edgeFalloff;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setControlModule(ModuleBase controlModule) {
        assert (this.sourceModules != null);
        this.sourceModules[2] = controlModule;
    }
}

