/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.Interp;
import libnoiseforjava.Misc;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ModuleBase;

public class Terrace
extends ModuleBase {
    int controlPointCount;
    boolean invertTerraces;
    double[] controlPoints;

    public Terrace(ModuleBase sourceModule) throws ExceptionInvalidParam {
        super(1);
        this.setSourceModule(0, sourceModule);
        this.controlPointCount = 0;
        this.invertTerraces = false;
        this.controlPoints = new double[0];
    }

    public void addControlPoint(double value) throws ExceptionInvalidParam {
        int insertionPos = this.findInsertionPos(value);
        this.insertAtPos(insertionPos, value);
    }

    public void clearAllControlPoints() {
        this.controlPoints = null;
        this.controlPointCount = 0;
    }

    public int findInsertionPos(double value) throws ExceptionInvalidParam {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.controlPointCount && !(value < this.controlPoints[insertionPos]); ++insertionPos) {
            if (value != this.controlPoints[insertionPos]) continue;
            throw new ExceptionInvalidParam("Invalid Parameter in Terrace Noise Moduled");
        }
        return insertionPos;
    }

    @Override
    public double getValue(double x, double y, double z) {
        int index1;
        int indexPos;
        assert (this.sourceModules[0] != null);
        assert (this.controlPointCount >= 2);
        double sourceModuleValue = this.sourceModules[0].getValue(x, y, z);
        for (indexPos = 0; indexPos < this.controlPointCount && !(sourceModuleValue < this.controlPoints[indexPos]); ++indexPos) {
        }
        int index0 = Misc.ClampValue(indexPos - 1, 0, this.controlPointCount - 1);
        if (index0 == (index1 = Misc.ClampValue(indexPos, 0, this.controlPointCount - 1))) {
            return this.controlPoints[index1];
        }
        double value0 = this.controlPoints[index0];
        double value1 = this.controlPoints[index1];
        double alpha = (sourceModuleValue - value0) / (value1 - value0);
        if (this.invertTerraces) {
            alpha = 1.0 - alpha;
            double tempValue = value0;
            value0 = value1;
            value1 = tempValue;
        }
        alpha *= alpha;
        return Interp.linearInterp(value0, value1, alpha);
    }

    public void insertAtPos(int insertionPos, double value) {
        double[] newControlPoints = new double[this.controlPointCount + 1];
        for (int i2 = 0; i2 < this.controlPointCount; ++i2) {
            if (i2 < insertionPos) {
                newControlPoints[i2] = this.controlPoints[i2];
                continue;
            }
            newControlPoints[i2 + 1] = this.controlPoints[i2];
        }
        this.controlPoints = newControlPoints;
        ++this.controlPointCount;
        this.controlPoints[insertionPos] = value;
    }

    void makeControlPoints(int controlPointCount) throws ExceptionInvalidParam {
        if (controlPointCount < 2) {
            throw new ExceptionInvalidParam("Invalid Parameter in Terrace Noise Module");
        }
        this.clearAllControlPoints();
        double terraceStep = 2.0 / ((double)controlPointCount - 1.0);
        double curValue = -1.0;
        for (int i2 = 0; i2 < controlPointCount; ++i2) {
            this.addControlPoint(curValue);
            curValue += terraceStep;
        }
    }

    public double[] getControlPointArray() {
        return this.controlPoints;
    }

    public int getControlPointCount() {
        return this.controlPointCount;
    }

    public void invertTerraces(boolean invert) {
        if (invert) {
            this.invertTerraces = invert;
        }
    }

    public boolean isTerracesInverted() {
        return this.invertTerraces;
    }
}

