/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.module.ModuleBase;
import libnoiseforjava.module.Perlin;

public class Turbulence
extends ModuleBase {
    static final double DEFAULT_TURBULENCE_FREQUENCY = 1.0;
    static final double DEFAULT_TURBULENCE_POWER = 1.0;
    static final int DEFAULT_TURBULENCE_ROUGHNESS = 3;
    static final int DEFAULT_TURBULENCE_SEED = 0;
    double power;
    Perlin xDistortModule;
    Perlin yDistortModule;
    Perlin zDistortModule;

    public Turbulence(ModuleBase sourceModule) throws ExceptionInvalidParam {
        super(1);
        this.setSourceModule(0, sourceModule);
        this.power = 1.0;
        this.xDistortModule = new Perlin();
        this.yDistortModule = new Perlin();
        this.zDistortModule = new Perlin();
        this.setSeed(0);
        this.setFrequency(1.0);
        this.setRoughness(3);
    }

    public double getFrequency() {
        return this.xDistortModule.getFrequency();
    }

    public int getSeed() {
        return this.xDistortModule.getSeed();
    }

    @Override
    public double getValue(double x, double y, double z) {
        assert (this.sourceModules[0] != null);
        double x0 = x + 0.189422607421875;
        double y0 = y + 0.99371337890625;
        double z0 = z + 0.4781646728515625;
        double x1 = x + 0.4046478271484375;
        double y1 = y + 0.276611328125;
        double z1 = z + 0.9230499267578125;
        double x2 = x + 0.82122802734375;
        double y2 = y + 0.1710968017578125;
        double z2 = z + 0.6842803955078125;
        double xDistort = x + this.xDistortModule.getValue(x0, y0, z0) * this.power;
        double yDistort = y + this.yDistortModule.getValue(x1, y1, z1) * this.power;
        double zDistort = z + this.zDistortModule.getValue(x2, y2, z2) * this.power;
        return this.sourceModules[0].getValue(xDistort, yDistort, zDistort);
    }

    public void setSeed(int seed) {
        this.xDistortModule.setSeed(seed);
        this.yDistortModule.setSeed(seed + 1);
        this.zDistortModule.setSeed(seed + 2);
    }

    public double getPower() {
        return this.power;
    }

    public int getRoughnessCount() {
        return this.xDistortModule.getOctaveCount();
    }

    public void setFrequency(double frequency) {
        this.xDistortModule.setFrequency(frequency);
        this.yDistortModule.setFrequency(frequency);
        this.zDistortModule.setFrequency(frequency);
    }

    public void setPower(double power) {
        this.power = power;
    }

    public void setRoughness(int roughness) throws ExceptionInvalidParam {
        this.xDistortModule.setOctaveCount(roughness);
        this.yDistortModule.setOctaveCount(roughness);
        this.zDistortModule.setOctaveCount(roughness);
    }
}

