/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.module;

import libnoiseforjava.NoiseGen;
import libnoiseforjava.module.ModuleBase;

public class Voronoi
extends ModuleBase {
    static final double DEFAULT_VORONOI_DISPLACEMENT = 1.0;
    static final double DEFAULT_VORONOI_FREQUENCY = 1.0;
    static final int DEFAULT_VORONOI_SEED = 0;
    private static final double SQRT_3 = 1.7320508075688772;
    double displacement = 1.0;
    boolean enableDistance = false;
    double frequency = 1.0;
    int seed = 0;

    public Voronoi() {
        super(0);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double value;
        int xInt = x > 0.0 ? (int)x : (int)(x *= this.frequency) - 1;
        int yInt = y > 0.0 ? (int)y : (int)(y *= this.frequency) - 1;
        int zInt = z > 0.0 ? (int)z : (int)(z *= this.frequency) - 1;
        double minDist = 2.147483647E9;
        double xCandidate = 0.0;
        double yCandidate = 0.0;
        double zCandidate = 0.0;
        for (int zCur = zInt - 2; zCur <= zInt + 2; ++zCur) {
            for (int yCur = yInt - 2; yCur <= yInt + 2; ++yCur) {
                for (int xCur = xInt - 2; xCur <= xInt + 2; ++xCur) {
                    double zPos;
                    double zDist;
                    double yPos;
                    double yDist;
                    double xPos = (double)xCur + NoiseGen.ValueNoise3D(xCur, yCur, zCur, this.seed);
                    double xDist = xPos - x;
                    double dist = xDist * xDist + (yDist = (yPos = (double)yCur + NoiseGen.ValueNoise3D(xCur, yCur, zCur, this.seed + 1)) - y) * yDist + (zDist = (zPos = (double)zCur + NoiseGen.ValueNoise3D(xCur, yCur, zCur, this.seed + 2)) - z) * zDist;
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    xCandidate = xPos;
                    yCandidate = yPos;
                    zCandidate = zPos;
                }
            }
        }
        if (this.enableDistance) {
            double xDist = xCandidate - x;
            double yDist = yCandidate - y;
            double zDist = zCandidate - z;
            value = Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist) * 1.7320508075688772 - 1.0;
        } else {
            value = 0.0;
        }
        return value + this.displacement * NoiseGen.ValueNoise3D((int)Math.floor(xCandidate), (int)Math.floor(yCandidate), (int)Math.floor(zCandidate), this.seed);
    }

    public void enableDistance(boolean enable) {
        this.enableDistance = enable;
    }

    public double getDisplacement() {
        return this.displacement;
    }

    public double GetFrequency() {
        return this.frequency;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean IsDistanceEnabled() {
        return this.enableDistance;
    }

    public void setDisplacement(double displacement) {
        this.displacement = displacement;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }
}

