/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.Misc;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.util.ColorCafe;
import libnoiseforjava.util.GradientPoint;
import libnoiseforjava.util.MiscUtilities;

public class GradientColor {
    GradientPoint[] gradientPoints = new GradientPoint[1];
    int gradientPointCount;
    ColorCafe workingColor;

    public GradientColor() {
        this.gradientPoints[0] = new GradientPoint(0.0, new ColorCafe(0, 0, 0, 0));
    }

    public void addGradientPoint(double gradientPos, ColorCafe gradientColor) throws ExceptionInvalidParam {
        int insertionPos = this.findInsertionPos(gradientPos);
        this.insertAtPos(insertionPos, gradientPos, gradientColor);
    }

    public void clear() {
        this.gradientPoints = null;
        this.gradientPointCount = 0;
    }

    public int findInsertionPos(double gradientPos) throws ExceptionInvalidParam {
        int insertionPos;
        for (insertionPos = 0; insertionPos < this.gradientPointCount && !(gradientPos < this.gradientPoints[insertionPos].position); ++insertionPos) {
            if (gradientPos != this.gradientPoints[insertionPos].position) continue;
            throw new ExceptionInvalidParam("Invalid Parameter in Gradient Color");
        }
        return insertionPos;
    }

    public ColorCafe getColor(double gradientPos) {
        int index1;
        int indexPos;
        assert (this.gradientPointCount >= 2);
        for (indexPos = 0; indexPos < this.gradientPointCount && !(gradientPos < this.gradientPoints[indexPos].position); ++indexPos) {
        }
        int index0 = Misc.ClampValue(indexPos - 1, 0, this.gradientPointCount - 1);
        if (index0 == (index1 = Misc.ClampValue(indexPos, 0, this.gradientPointCount - 1))) {
            this.workingColor = this.gradientPoints[index1].color;
            return this.workingColor;
        }
        double input0 = this.gradientPoints[index0].position;
        double input1 = this.gradientPoints[index1].position;
        double alpha = (gradientPos - input0) / (input1 - input0);
        ColorCafe color0 = this.gradientPoints[index0].color;
        ColorCafe color1 = this.gradientPoints[index1].color;
        this.workingColor = MiscUtilities.linearInterpColor(color0, color1, (float)alpha);
        return this.workingColor;
    }

    public void insertAtPos(int insertionPos, double gradientPos, ColorCafe gradientColor) {
        GradientPoint[] newGradientPoints = new GradientPoint[this.gradientPointCount + 1];
        for (int t = 0; t < this.gradientPointCount + 1; ++t) {
            newGradientPoints[t] = new GradientPoint();
        }
        for (int i2 = 0; i2 < this.gradientPointCount; ++i2) {
            if (i2 < insertionPos) {
                newGradientPoints[i2] = this.gradientPoints[i2];
                continue;
            }
            newGradientPoints[i2 + 1] = this.gradientPoints[i2];
        }
        this.gradientPoints = newGradientPoints;
        ++this.gradientPointCount;
        this.gradientPoints[insertionPos].position = gradientPos;
        this.gradientPoints[insertionPos].color = gradientColor;
    }

    public GradientPoint[] getGradientPointArray() {
        return this.gradientPoints;
    }

    public int getGradientPointCount() {
        return this.gradientPointCount;
    }
}

