/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.util.ColorCafe;

public class ImageCafe {
    ColorCafe borderValue;
    int height;
    int width;
    ColorCafe[][] imageCafeColors;

    public ImageCafe(int width, int height) throws ExceptionInvalidParam {
        this.setSize(width, height);
        this.borderValue = new ColorCafe(0, 0, 0, 0);
        this.imageCafeColors = new ColorCafe[width][height];
    }

    public ColorCafe getValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.imageCafeColors[x][y];
        }
        return this.borderValue;
    }

    public void setSize(int width, int height) throws ExceptionInvalidParam {
        if (width < 0 || height < 0) {
            throw new ExceptionInvalidParam("Invalid Parameter in ImageCafe");
        }
        this.width = width;
        this.height = height;
    }

    public void setValue(int x, int y, ColorCafe value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.imageCafeColors[x][y] = value;
        }
    }

    public ColorCafe getBorderValue() {
        return this.borderValue;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBorderValue(ColorCafe borderValue) {
        this.borderValue = borderValue;
    }
}

