/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.exception.ExceptionInvalidParam;

public class NoiseMap {
    int height;
    int width;
    double[][] noiseMap;
    double borderValue;

    public NoiseMap(int width, int height) throws ExceptionInvalidParam {
        this.setSize(width, height);
        this.noiseMap = new double[width][height];
        this.borderValue = 0.0;
    }

    public double getValue(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            return this.noiseMap[x][y];
        }
        return this.borderValue;
    }

    public void setSize(int width, int height) throws ExceptionInvalidParam {
        if (width < 1 || height < 1) {
            throw new ExceptionInvalidParam("Invalid parameter in NoiseMap");
        }
        this.width = width;
        this.height = height;
    }

    public void setValue(int x, int y, double value) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.noiseMap[x][y] = value;
        }
    }

    public double getBorderValue() {
        return this.borderValue;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setBorderValue(double borderValue) {
        this.borderValue = borderValue;
    }
}

