/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.model.Cylinder;
import libnoiseforjava.util.NoiseMapBuilder;

public class NoiseMapBuilderCylinder
extends NoiseMapBuilder {
    double lowerAngleBound = 0.0;
    double lowerHeightBound = 0.0;
    double upperAngleBound = 0.0;
    double upperHeightBound = 0.0;

    @Override
    public void build() throws ExceptionInvalidParam {
        if (this.upperAngleBound <= this.lowerAngleBound || this.upperHeightBound <= this.lowerHeightBound || this.destWidth <= 0 || this.destHeight <= 0 || this.sourceModule == null || this.destNoiseMap == null) {
            throw new ExceptionInvalidParam("Invalid Parameter in NoiseMapBuilderCylinder");
        }
        this.destNoiseMap.setSize(this.destWidth, this.destHeight);
        Cylinder cylinderModel = new Cylinder();
        cylinderModel.setModule(this.sourceModule);
        double angleExtent = this.upperAngleBound - this.lowerAngleBound;
        double heightExtent = this.upperHeightBound - this.lowerHeightBound;
        double xDelta = angleExtent / (double)this.destWidth;
        double yDelta = heightExtent / (double)this.destHeight;
        double curAngle = this.lowerAngleBound;
        double curHeight = this.lowerHeightBound;
        for (int y = 0; y < this.destHeight; ++y) {
            curAngle = this.lowerAngleBound;
            for (int x = 0; x < this.destWidth; ++x) {
                float curValue = (float)cylinderModel.getValue(curAngle, curHeight);
                this.destNoiseMap.setValue(x, y, curValue);
                curAngle += xDelta;
            }
            curHeight += yDelta;
            this.setCallback(y);
        }
    }

    public double getLowerAngleBound() {
        return this.lowerAngleBound;
    }

    public double getLowerHeightBound() {
        return this.lowerHeightBound;
    }

    public double GetUpperAngleBound() {
        return this.upperAngleBound;
    }

    public double getUpperHeightBound() {
        return this.upperHeightBound;
    }

    public void setBounds(double lowerAngleBound, double upperAngleBound, double lowerHeightBound, double upperHeightBound) throws ExceptionInvalidParam {
        if (lowerAngleBound >= upperAngleBound || lowerHeightBound >= upperHeightBound) {
            throw new ExceptionInvalidParam("Invalid Parameter in NoiseMapBuilder Cylinder");
        }
        this.lowerAngleBound = lowerAngleBound;
        this.upperAngleBound = upperAngleBound;
        this.lowerHeightBound = lowerHeightBound;
        this.upperHeightBound = upperHeightBound;
    }

    public double getUpperAngleBound() {
        return this.upperAngleBound;
    }

    public void setLowerAngleBound(double lowerAngleBound) {
        this.lowerAngleBound = lowerAngleBound;
    }

    public void setLowerHeightBound(double lowerHeightBound) {
        this.lowerHeightBound = lowerHeightBound;
    }

    public void setUpperAngleBound(double upperAngleBound) {
        this.upperAngleBound = upperAngleBound;
    }

    public void setUpperHeightBound(double upperHeightBound) {
        this.upperHeightBound = upperHeightBound;
    }
}

