/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.Interp;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.model.Plane;
import libnoiseforjava.util.NoiseMapBuilder;

public class NoiseMapBuilderPlane
extends NoiseMapBuilder {
    boolean isSeamlessEnabled = false;
    double lowerXBound = 0.0;
    double lowerZBound = 0.0;
    double upperXBound = 0.0;
    double upperZBound = 0.0;

    public NoiseMapBuilderPlane() throws ExceptionInvalidParam {
    }

    public NoiseMapBuilderPlane(int height, int width) throws ExceptionInvalidParam {
        super(height, width);
    }

    @Override
    public void build() throws ExceptionInvalidParam {
        if (this.upperXBound <= this.lowerXBound || this.upperZBound <= this.lowerZBound || this.destWidth <= 0 || this.destHeight <= 0 || this.sourceModule == null || this.destNoiseMap == null) {
            throw new ExceptionInvalidParam("Invalid parameter in NoiseMapBuilderPlane");
        }
        this.destNoiseMap.setSize(this.destWidth, this.destHeight);
        Plane planeModel = new Plane();
        planeModel.setModule(this.sourceModule);
        double xExtent = this.upperXBound - this.lowerXBound;
        double zExtent = this.upperZBound - this.lowerZBound;
        double xDelta = xExtent / (double)this.destWidth;
        double zDelta = zExtent / (double)this.destHeight;
        double xCur = this.lowerXBound;
        double zCur = this.lowerZBound;
        for (int z = 0; z < this.destHeight; ++z) {
            xCur = this.lowerXBound;
            for (int x = 0; x < this.destWidth; ++x) {
                double finalValue;
                if (!this.isSeamlessEnabled) {
                    finalValue = planeModel.getValue(xCur, zCur);
                } else {
                    double swValue = planeModel.getValue(xCur, zCur);
                    double seValue = planeModel.getValue(xCur + xExtent, zCur);
                    double nwValue = planeModel.getValue(xCur, zCur + zExtent);
                    double neValue = planeModel.getValue(xCur + xExtent, zCur + zExtent);
                    double xBlend = 1.0 - (xCur - this.lowerXBound) / xExtent;
                    double zBlend = 1.0 - (zCur - this.lowerZBound) / zExtent;
                    double z0 = Interp.linearInterp(swValue, seValue, xBlend);
                    double z1 = Interp.linearInterp(nwValue, neValue, xBlend);
                    finalValue = Interp.linearInterp(z0, z1, zBlend);
                }
                this.destNoiseMap.setValue(x, z, finalValue);
                xCur += xDelta;
            }
            zCur += zDelta;
            this.setCallback(z);
        }
    }

    public void enableSeamless(boolean enable) {
        this.isSeamlessEnabled = enable;
    }

    public double getLowerXBound() {
        return this.lowerXBound;
    }

    public double getLowerZBound() {
        return this.lowerZBound;
    }

    public double getUpperXBound() {
        return this.upperXBound;
    }

    public double getUpperZBound() {
        return this.upperZBound;
    }

    public boolean isSeamlessEnabled() {
        return this.isSeamlessEnabled;
    }

    public void setBounds(double lowerXBound, double upperXBound, double lowerZBound, double upperZBound) throws ExceptionInvalidParam {
        if (lowerXBound >= upperXBound || lowerZBound >= upperZBound) {
            throw new ExceptionInvalidParam("Invalid parameter in NoiseMapBuilderPlane");
        }
        this.lowerXBound = lowerXBound;
        this.upperXBound = upperXBound;
        this.lowerZBound = lowerZBound;
        this.upperZBound = upperZBound;
    }

    public void setLowerXBound(double lowerXBound) {
        this.lowerXBound = lowerXBound;
    }

    public void setLowerZBound(double lowerZBound) {
        this.lowerZBound = lowerZBound;
    }

    public void setUpperXBound(double upperXBound) {
        this.upperXBound = upperXBound;
    }

    public void setUpperZBound(double upperZBound) {
        this.upperZBound = upperZBound;
    }
}

