/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.model.Sphere;
import libnoiseforjava.util.NoiseMapBuilder;

public class NoiseMapBuilderSphere
extends NoiseMapBuilder {
    double eastLonBound = 0.0;
    double northLatBound = 0.0;
    double southLatBound = 0.0;
    double westLonBound = 0.0;

    @Override
    public void build() throws ExceptionInvalidParam {
        if (this.eastLonBound <= this.westLonBound || this.northLatBound <= this.southLatBound || this.destWidth <= 0 || this.destHeight <= 0 || this.sourceModule == null || this.destNoiseMap == null) {
            throw new ExceptionInvalidParam("Invalid Parameter in NoiseMapBuilderSphere");
        }
        this.destNoiseMap.setSize(this.destWidth, this.destHeight);
        Sphere sphereModel = new Sphere();
        sphereModel.setModule(this.sourceModule);
        double lonExtent = this.eastLonBound - this.westLonBound;
        double latExtent = this.northLatBound - this.southLatBound;
        double xDelta = lonExtent / (double)this.destWidth;
        double yDelta = latExtent / (double)this.destHeight;
        double curLon = this.westLonBound;
        double curLat = this.southLatBound;
        for (int y = 0; y < this.destHeight; ++y) {
            curLon = this.westLonBound;
            for (int x = 0; x < this.destWidth; ++x) {
                float curValue = (float)sphereModel.getValue(curLat, curLon);
                this.destNoiseMap.setValue(x, y, curValue);
                curLon += xDelta;
            }
            curLat += yDelta;
            this.setCallback(y);
        }
    }

    public double getEastLonBound() {
        return this.eastLonBound;
    }

    public double getNorthLatBound() {
        return this.northLatBound;
    }

    public double getSouthLatBound() {
        return this.southLatBound;
    }

    public double getWestLonBound() {
        return this.westLonBound;
    }

    public void setBounds(double southLatBound, double northLatBound, double westLonBound, double eastLonBound) throws ExceptionInvalidParam {
        if (southLatBound >= northLatBound || westLonBound >= eastLonBound) {
            throw new ExceptionInvalidParam("Invalid Parameter in NoiseMapBuilderSphere");
        }
        this.southLatBound = southLatBound;
        this.northLatBound = northLatBound;
        this.westLonBound = westLonBound;
        this.eastLonBound = eastLonBound;
    }

    public void setEastLonBound(double eastLonBound) {
        this.eastLonBound = eastLonBound;
    }

    public void setNorthLatBound(double northLatBound) {
        this.northLatBound = northLatBound;
    }

    public void setSouthLatBound(double southLatBound) {
        this.southLatBound = southLatBound;
    }

    public void setWestLonBound(double westLonBound) {
        this.westLonBound = westLonBound;
    }
}

