/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.Interp;
import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.util.ColorCafe;
import libnoiseforjava.util.GradientColor;
import libnoiseforjava.util.ImageCafe;
import libnoiseforjava.util.NoiseMap;

public class RendererImage {
    static final double SQRT_2 = 1.4142135623730951;
    double cosAzimuth;
    double cosElev;
    GradientColor gradient;
    boolean isLightEnabled = false;
    boolean isWrapEnabled = false;
    double lightAzimuth = 45.0;
    double lightBrightness = 1.0;
    ColorCafe lightColor = new ColorCafe(255, 255, 255, 255);
    double lightContrast = 1.0;
    double lightElev = 45.0;
    double lightIntensity = 1.0;
    ImageCafe backgroundImage = null;
    ImageCafe destImageCafe = null;
    NoiseMap sourceNoiseMap = null;
    boolean recalcLightValues = true;
    double sinAzimuth;
    double sinElev;

    public RendererImage() throws ExceptionInvalidParam {
        this.buildGrayscaleGradient();
    }

    public void addGradientPoint(double gradientPos, ColorCafe gradientColor) throws ExceptionInvalidParam {
        this.gradient.addGradientPoint(gradientPos, gradientColor);
    }

    public void buildGrayscaleGradient() throws ExceptionInvalidParam {
        this.clearGradient();
        this.gradient.addGradientPoint(-1.0, new ColorCafe(0, 0, 0, 255));
        this.gradient.addGradientPoint(1.0, new ColorCafe(255, 255, 255, 255));
    }

    public void buildTerrainGradient() throws ExceptionInvalidParam {
        this.clearGradient();
        this.gradient.addGradientPoint(-1.0, new ColorCafe(0, 0, 128, 255));
        this.gradient.addGradientPoint(-0.2, new ColorCafe(32, 64, 128, 255));
        this.gradient.addGradientPoint(-0.04, new ColorCafe(64, 96, 192, 255));
        this.gradient.addGradientPoint(-0.02, new ColorCafe(192, 192, 128, 255));
        this.gradient.addGradientPoint(0.0, new ColorCafe(0, 192, 0, 255));
        this.gradient.addGradientPoint(0.25, new ColorCafe(192, 192, 0, 255));
        this.gradient.addGradientPoint(0.5, new ColorCafe(160, 96, 64, 255));
        this.gradient.addGradientPoint(0.75, new ColorCafe(128, 255, 255, 255));
        this.gradient.addGradientPoint(1.0, new ColorCafe(255, 255, 255, 255));
    }

    public ColorCafe calcDestColor(ColorCafe sourceColor, ColorCafe backgroundColor, double lightValue) {
        double sourceRed = (double)sourceColor.red / 255.0;
        double sourceGreen = (double)sourceColor.green / 255.0;
        double sourceBlue = (double)sourceColor.blue / 255.0;
        double sourceAlpha = (double)sourceColor.alpha / 255.0;
        double backgroundRed = (double)backgroundColor.red / 255.0;
        double backgroundGreen = (double)backgroundColor.green / 255.0;
        double backgroundBlue = (double)backgroundColor.blue / 255.0;
        double red = Interp.linearInterp(backgroundRed, sourceRed, sourceAlpha);
        double green = Interp.linearInterp(backgroundGreen, sourceGreen, sourceAlpha);
        double blue = Interp.linearInterp(backgroundBlue, sourceBlue, sourceAlpha);
        if (this.isLightEnabled) {
            double lightRed = lightValue * (double)this.lightColor.red / 255.0;
            double lightGreen = lightValue * (double)this.lightColor.green / 255.0;
            double lightBlue = lightValue * (double)this.lightColor.blue / 255.0;
            red *= lightRed;
            green *= lightGreen;
            blue *= lightBlue;
        }
        red = red < 0.0 ? 0.0 : red;
        red = red > 1.0 ? 1.0 : red;
        green = green < 0.0 ? 0.0 : green;
        green = green > 1.0 ? 1.0 : green;
        blue = blue < 0.0 ? 0.0 : blue;
        blue = blue > 1.0 ? 1.0 : blue;
        ColorCafe newColor = new ColorCafe((int)(red * 255.0) & 0xFF, (int)(green * 255.0) & 0xFF, (int)(blue * 255.0) & 0xFF, Math.max(sourceColor.alpha, backgroundColor.alpha));
        return newColor;
    }

    public double calcLightIntensity(double center, double left, double right, double down, double up) {
        double iy;
        double io;
        double I_MAX;
        double ix;
        double intensity;
        if (this.recalcLightValues) {
            this.cosAzimuth = Math.cos(Math.toRadians(this.lightAzimuth));
            this.sinAzimuth = Math.sin(Math.toRadians(this.lightAzimuth));
            this.cosElev = Math.cos(Math.toRadians(this.lightElev));
            this.sinElev = Math.sin(Math.toRadians(this.lightElev));
            this.recalcLightValues = false;
        }
        if ((intensity = (ix = ((I_MAX = 1.0) - (io = I_MAX * 1.4142135623730951 * this.sinElev / 2.0)) * this.lightContrast * 1.4142135623730951 * this.cosElev * this.cosAzimuth) * (left - right) + (iy = (I_MAX - io) * this.lightContrast * 1.4142135623730951 * this.cosElev * this.sinAzimuth) * (down - up) + io) < 0.0) {
            intensity = 0.0;
        }
        return intensity;
    }

    public void clearGradient() {
        this.gradient = new GradientColor();
        this.gradient.clear();
    }

    public void render() throws ExceptionInvalidParam {
        if (this.sourceNoiseMap == null || this.destImageCafe == null || this.sourceNoiseMap.getWidth() <= 0 || this.sourceNoiseMap.getHeight() <= 0 || this.gradient.getGradientPointCount() < 2) {
            throw new ExceptionInvalidParam("Invalid Parameter in RendererImage");
        }
        int width = this.sourceNoiseMap.getWidth();
        int height = this.sourceNoiseMap.getHeight();
        if (this.backgroundImage != null && (this.backgroundImage.getWidth() != width || this.backgroundImage.getHeight() != height)) {
            throw new ExceptionInvalidParam("Invalid Parameter in RendererImage");
        }
        if (this.destImageCafe != this.backgroundImage) {
            this.destImageCafe.setSize(width, height);
        }
        for (int y = 0; y < height; ++y) {
            ColorCafe background = new ColorCafe(255, 255, 255, 255);
            for (int x = 0; x < width; ++x) {
                double lightIntensity;
                ColorCafe destColor = this.gradient.getColor(this.sourceNoiseMap.getValue(x, y));
                if (this.isLightEnabled) {
                    int yUpOffset;
                    int yDownOffset;
                    int xRightOffset;
                    int xLeftOffset;
                    if (this.isWrapEnabled) {
                        if (x == 0) {
                            xLeftOffset = width - 1;
                            xRightOffset = 1;
                        } else if (x == width - 1) {
                            xLeftOffset = -1;
                            xRightOffset = -(width - 1);
                        } else {
                            xLeftOffset = -1;
                            xRightOffset = 1;
                        }
                        if (y == 0) {
                            yDownOffset = height - 1;
                            yUpOffset = 1;
                        } else if (y == height - 1) {
                            yDownOffset = -1;
                            yUpOffset = -(height - 1);
                        } else {
                            yDownOffset = -1;
                            yUpOffset = 1;
                        }
                    } else {
                        if (x == 0) {
                            xLeftOffset = 0;
                            xRightOffset = 1;
                        } else if (x == width - 1) {
                            xLeftOffset = -1;
                            xRightOffset = 0;
                        } else {
                            xLeftOffset = -1;
                            xRightOffset = 1;
                        }
                        if (y == 0) {
                            yDownOffset = 0;
                            yUpOffset = 1;
                        } else if (y == height - 1) {
                            yDownOffset = -1;
                            yUpOffset = 0;
                        } else {
                            yDownOffset = -1;
                            yUpOffset = 1;
                        }
                    }
                    double nc = this.sourceNoiseMap.getValue(x, y);
                    double nl = this.sourceNoiseMap.getValue(x + xLeftOffset, y);
                    double nr = this.sourceNoiseMap.getValue(x + xRightOffset, y);
                    double nd = this.sourceNoiseMap.getValue(x, y + yDownOffset);
                    double nu = this.sourceNoiseMap.getValue(x, y + yUpOffset);
                    lightIntensity = this.calcLightIntensity(nc, nl, nr, nd, nu);
                    lightIntensity *= this.lightBrightness;
                } else {
                    lightIntensity = 1.0;
                }
                ColorCafe backgroundColor = new ColorCafe(255, 255, 255, 255);
                if (this.backgroundImage != null) {
                    backgroundColor = this.backgroundImage.getValue(x, y);
                }
                this.destImageCafe.setValue(x, y, this.calcDestColor(destColor, backgroundColor, lightIntensity));
            }
        }
    }

    public void enableLight(boolean enable) {
        this.isLightEnabled = enable;
    }

    public void enableWrap(boolean enable) {
        this.isWrapEnabled = enable;
    }

    public double getLightAzimuth() {
        return this.lightAzimuth;
    }

    public double getLightBrightness() {
        return this.lightBrightness;
    }

    public ColorCafe getLightColor() {
        return this.lightColor;
    }

    public double getLightContrast() {
        return this.lightContrast;
    }

    public double getLightElev() {
        return this.lightElev;
    }

    public double getLightIntensity() {
        return this.lightIntensity;
    }

    public boolean isLightEnabled() {
        return this.isLightEnabled;
    }

    public boolean isWrapEnabled() {
        return this.isWrapEnabled;
    }

    public void setBackgroundImage(ImageCafe backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setDestImage(ImageCafe destImage) {
        this.destImageCafe = destImage;
    }

    public void setLightAzimuth(double lightAzimuth) {
        this.lightAzimuth = lightAzimuth;
        this.recalcLightValues = true;
    }

    public void setLightBrightness(double lightBrightness) {
        this.lightBrightness = lightBrightness;
        this.recalcLightValues = true;
    }

    public void setLightColor(ColorCafe lightColor) {
        this.lightColor = lightColor;
    }

    public void setLightContrast(double lightContrast) throws ExceptionInvalidParam {
        if (lightContrast <= 0.0) {
            throw new ExceptionInvalidParam("Invalid Parameter in RendererImage");
        }
        this.lightContrast = lightContrast;
        this.recalcLightValues = true;
    }

    public void setLightElev(double lightElev) {
        this.lightElev = lightElev;
        this.recalcLightValues = true;
    }

    public void setLightIntensity(double lightIntensity) throws ExceptionInvalidParam {
        if (lightIntensity < 0.0) {
            throw new ExceptionInvalidParam("Invalid Parameter in RendererImage");
        }
        this.lightIntensity = lightIntensity;
        this.recalcLightValues = true;
    }

    public void setSourceNoiseMap(NoiseMap sourceNoiseMap) {
        this.sourceNoiseMap = sourceNoiseMap;
    }
}

