/*
 * Decompiled with CFR 0.152.
 */
package libnoiseforjava.util;

import libnoiseforjava.exception.ExceptionInvalidParam;
import libnoiseforjava.util.ColorCafe;
import libnoiseforjava.util.ImageCafe;
import libnoiseforjava.util.NoiseMap;

public class RendererNormalMap {
    double bumpHeight = 1.0;
    boolean isWrapEnabled = false;
    ImageCafe destImageCafe;
    NoiseMap sourceNoiseMap;

    public RendererNormalMap() throws ExceptionInvalidParam {
        this.destImageCafe = new ImageCafe(0, 0);
        this.sourceNoiseMap = new NoiseMap(0, 0);
    }

    public RendererNormalMap(int height, int width) throws ExceptionInvalidParam {
        this.destImageCafe = new ImageCafe(height, width);
        this.sourceNoiseMap = new NoiseMap(height, width);
    }

    public ColorCafe calcNormalColor(double nc, double nr, double nu, double bumpHeight) {
        double ncr = (nc *= bumpHeight) - (nr *= bumpHeight);
        double ncu = nc - (nu *= bumpHeight);
        double d = Math.sqrt(ncu * ncu + ncr * ncr + 1.0);
        double vxc = (nc - nr) / d;
        double vyc = (nc - nu) / d;
        double vzc = 1.0 / d;
        int xc = (int)Math.floor((vxc + 1.0) * 127.5) & 0xFF;
        int yc = (int)Math.floor((vyc + 1.0) * 127.5) & 0xFF;
        int zc = (int)Math.floor((vzc + 1.0) * 127.5) & 0xFF;
        return new ColorCafe(xc, yc, zc, 255);
    }

    public void render() throws ExceptionInvalidParam {
        if (this.sourceNoiseMap == null || this.destImageCafe == null || this.sourceNoiseMap.getWidth() <= 0 || this.sourceNoiseMap.getHeight() <= 0) {
            throw new ExceptionInvalidParam("Invalid Parameter in RendererNormalMap");
        }
        int width = this.sourceNoiseMap.getWidth();
        int height = this.sourceNoiseMap.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int yUpOffset;
                int xRightOffset;
                if (this.isWrapEnabled) {
                    xRightOffset = x == width - 1 ? -(width - 1) : 1;
                    yUpOffset = y == height - 1 ? -(height - 1) : 1;
                } else {
                    xRightOffset = x == width - 1 ? 0 : 1;
                    yUpOffset = y == height - 1 ? 0 : 1;
                }
                double nc = this.sourceNoiseMap.getValue(x, y);
                double nr = this.sourceNoiseMap.getValue(x + xRightOffset, y);
                double nu = this.sourceNoiseMap.getValue(x, y + yUpOffset);
                this.destImageCafe.setValue(x, y, this.calcNormalColor(nc, nr, nu, this.bumpHeight));
            }
        }
    }

    public void enableWrap(boolean enable) {
        this.isWrapEnabled = enable;
    }

    public double getBumpHeight() {
        return this.bumpHeight;
    }

    public boolean isWrapEnabled() {
        return this.isWrapEnabled;
    }

    public void setBumpHeight(double bumpHeight) {
        this.bumpHeight = bumpHeight;
    }

    public void setDestImage(ImageCafe destImage) {
        this.destImageCafe = destImage;
    }

    public void setSourceNoiseMap(NoiseMap sourceNoiseMap) {
        this.sourceNoiseMap = sourceNoiseMap;
    }

    public ImageCafe getDestImageCafe() {
        return this.destImageCafe;
    }

    public NoiseMap getSourceNoiseMap() {
        return this.sourceNoiseMap;
    }

    public void setDestImageCafe(ImageCafe destImageCafe) {
        this.destImageCafe = destImageCafe;
    }
}

