/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class EntityCommand
extends Command {
    private List<String> params = Arrays.asList("reload", "dump-existing");

    public EntityCommand(String name) {
        super(name);
        this.description = "Entity tick limiting commands";
        this.usageMessage = "/entity [reload|dump-existing]";
        this.setPermission("mohist.command.entity");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 1 && (sender.isOp() || this.testPermission(sender))) {
            for (String param : this.params) {
                if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                list.add(param);
            }
        }
        return list;
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0].toLowerCase(Locale.ENGLISH)) {
            case "reload": {
                MinecraftServer.entityConfig.load();
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "entity.yml reload complete.");
                break;
            }
            case "dump-existing": {
                MinecraftServer.entityConfig.save();
                sender.sendMessage((Object)((Object)ChatColor.GREEN) + "entity.yml updated with found Entities");
                break;
            }
            default: {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }
}

